/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.bridge.impl;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.TwoWayStringBridge;
import org.hibernate.search.bridge.spi.BridgeProvider;
import org.hibernate.search.bridge.util.impl.TwoWayString2FieldBridgeIgnoreAnalyzerAdaptor;
import org.hibernate.search.elasticsearch.bridge.builtin.time.impl.ElasticsearchInstantBridge;
import org.hibernate.search.elasticsearch.bridge.builtin.time.impl.ElasticsearchLocalDateBridge;
import org.hibernate.search.elasticsearch.bridge.builtin.time.impl.ElasticsearchLocalDateTimeBridge;
import org.hibernate.search.elasticsearch.bridge.builtin.time.impl.ElasticsearchLocalTimeBridge;
import org.hibernate.search.elasticsearch.bridge.builtin.time.impl.ElasticsearchMonthDayBridge;
import org.hibernate.search.elasticsearch.bridge.builtin.time.impl.ElasticsearchOffsetDateTimeBridge;
import org.hibernate.search.elasticsearch.bridge.builtin.time.impl.ElasticsearchOffsetTimeBridge;
import org.hibernate.search.elasticsearch.bridge.builtin.time.impl.ElasticsearchYearBridge;
import org.hibernate.search.elasticsearch.bridge.builtin.time.impl.ElasticsearchYearMonthBridge;
import org.hibernate.search.elasticsearch.bridge.builtin.time.impl.ElasticsearchZonedDateTimeBridge;
import org.hibernate.search.util.impl.CollectionHelper;

class ElasticsearchJavaTimeBridgeProvider
implements BridgeProvider {
    private final Map<String, FieldBridge> builtInBridges = ElasticsearchJavaTimeBridgeProvider.populateBridgeMap();

    ElasticsearchJavaTimeBridgeProvider() {
    }

    private static Map<String, FieldBridge> populateBridgeMap() {
        HashMap bridges = CollectionHelper.newHashMap((int)10);
        bridges.put(Year.class.getName(), new TwoWayString2FieldBridgeIgnoreAnalyzerAdaptor((TwoWayStringBridge)ElasticsearchYearBridge.INSTANCE));
        bridges.put(YearMonth.class.getName(), new TwoWayString2FieldBridgeIgnoreAnalyzerAdaptor((TwoWayStringBridge)ElasticsearchYearMonthBridge.INSTANCE));
        bridges.put(MonthDay.class.getName(), new TwoWayString2FieldBridgeIgnoreAnalyzerAdaptor((TwoWayStringBridge)ElasticsearchMonthDayBridge.INSTANCE));
        bridges.put(LocalDateTime.class.getName(), new TwoWayString2FieldBridgeIgnoreAnalyzerAdaptor((TwoWayStringBridge)ElasticsearchLocalDateTimeBridge.INSTANCE));
        bridges.put(LocalDate.class.getName(), new TwoWayString2FieldBridgeIgnoreAnalyzerAdaptor((TwoWayStringBridge)ElasticsearchLocalDateBridge.INSTANCE));
        bridges.put(LocalTime.class.getName(), new TwoWayString2FieldBridgeIgnoreAnalyzerAdaptor((TwoWayStringBridge)ElasticsearchLocalTimeBridge.INSTANCE));
        bridges.put(Instant.class.getName(), new TwoWayString2FieldBridgeIgnoreAnalyzerAdaptor((TwoWayStringBridge)ElasticsearchInstantBridge.INSTANCE));
        bridges.put(OffsetDateTime.class.getName(), new TwoWayString2FieldBridgeIgnoreAnalyzerAdaptor((TwoWayStringBridge)ElasticsearchOffsetDateTimeBridge.INSTANCE));
        bridges.put(OffsetTime.class.getName(), new TwoWayString2FieldBridgeIgnoreAnalyzerAdaptor((TwoWayStringBridge)ElasticsearchOffsetTimeBridge.INSTANCE));
        bridges.put(ZonedDateTime.class.getName(), new TwoWayString2FieldBridgeIgnoreAnalyzerAdaptor((TwoWayStringBridge)ElasticsearchZonedDateTimeBridge.INSTANCE));
        return bridges;
    }

    public FieldBridge provideFieldBridge(BridgeProvider.BridgeProviderContext bridgeProviderContext) {
        return this.builtInBridges.get(bridgeProviderContext.getReturnType().getName());
    }
}

