/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.gson.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Supplier;
import org.hibernate.search.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.elasticsearch.gson.impl.JsonArrayAccessor;
import org.hibernate.search.elasticsearch.gson.impl.JsonArrayAccessorImpl;
import org.hibernate.search.elasticsearch.gson.impl.JsonBooleanAccessorImpl;
import org.hibernate.search.elasticsearch.gson.impl.JsonCompositeAccessor;
import org.hibernate.search.elasticsearch.gson.impl.JsonDoubleAccessorImpl;
import org.hibernate.search.elasticsearch.gson.impl.JsonElementType;
import org.hibernate.search.elasticsearch.gson.impl.JsonFloatAccessorImpl;
import org.hibernate.search.elasticsearch.gson.impl.JsonIntegerAccessorImpl;
import org.hibernate.search.elasticsearch.gson.impl.JsonObjectAccessor;
import org.hibernate.search.elasticsearch.gson.impl.JsonObjectAccessorImpl;
import org.hibernate.search.elasticsearch.gson.impl.JsonStringAccessorImpl;
import org.hibernate.search.elasticsearch.gson.impl.NonRootJsonAccessor;
import org.hibernate.search.elasticsearch.gson.impl.UnexpectedJsonElementTypeException;
import org.hibernate.search.elasticsearch.gson.impl.UnknownTypeJsonAccessor;
import org.hibernate.search.elasticsearch.impl.JsonBuilder;

abstract class CrawlingJsonAccessor<P extends JsonElement>
extends NonRootJsonAccessor<P, JsonElement>
implements UnknownTypeJsonAccessor {
    public CrawlingJsonAccessor(JsonCompositeAccessor<P> parentAccessor) {
        super(parentAccessor);
    }

    @Override
    protected JsonCompositeAccessor<P> getParentAccessor() {
        return (JsonCompositeAccessor)super.getParentAccessor();
    }

    @Override
    public Optional<JsonElement> get(JsonObject root) throws UnexpectedJsonElementTypeException {
        return this.getParentAccessor().get(root).map(this::doGet);
    }

    protected abstract JsonElement doGet(P var1);

    @Override
    public void set(JsonObject root, JsonElement newValue) throws UnexpectedJsonElementTypeException {
        Object parent = this.getParentAccessor().getOrCreate(root);
        this.doSet(parent, newValue);
    }

    protected abstract void doSet(P var1, JsonElement var2);

    @Override
    public JsonElement getOrCreate(JsonObject root, Supplier<? extends JsonElement> newValueSupplier) throws UnexpectedJsonElementTypeException {
        Object parent = this.getParentAccessor().getOrCreate(root);
        JsonElement currentValue = this.doGet(parent);
        if (currentValue == null || currentValue.isJsonNull()) {
            JsonElement result = newValueSupplier.get();
            this.doSet(parent, result);
            return result;
        }
        return currentValue;
    }

    @Override
    public void add(JsonObject root, JsonElement newValue) throws UnexpectedJsonElementTypeException {
        Object parent = this.getParentAccessor().getOrCreate(root);
        JsonElement currentValue = this.doGet(parent);
        if (currentValue == null) {
            this.doSet(parent, newValue);
        } else if (JsonElementType.ARRAY.isInstance(currentValue)) {
            JsonElementType.ARRAY.fromElement(currentValue).add(newValue);
        } else if (JsonElementType.PRIMITIVE.isInstance(currentValue) || JsonElementType.NULL.isInstance(currentValue)) {
            this.doSet(parent, (JsonElement)JsonBuilder.array().add(currentValue).add(newValue).build());
        } else {
            throw new UnexpectedJsonElementTypeException(this, Arrays.asList(JsonElementType.ARRAY, JsonElementType.PRIMITIVE, JsonElementType.NULL), currentValue);
        }
    }

    @Override
    public JsonObjectAccessor asObject() {
        return new JsonObjectAccessorImpl(this);
    }

    @Override
    public JsonArrayAccessor asArray() {
        return new JsonArrayAccessorImpl(this);
    }

    @Override
    public JsonAccessor<String> asString() {
        return new JsonStringAccessorImpl(this);
    }

    @Override
    public JsonAccessor<Boolean> asBoolean() {
        return new JsonBooleanAccessorImpl(this);
    }

    @Override
    public JsonAccessor<Integer> asInteger() {
        return new JsonIntegerAccessorImpl(this);
    }

    @Override
    public JsonAccessor<Float> asFloat() {
        return new JsonFloatAccessorImpl(this);
    }

    @Override
    public JsonAccessor<Double> asDouble() {
        return new JsonDoubleAccessorImpl(this);
    }

    @Override
    public UnknownTypeJsonAccessor element(int index) {
        return this.asArray().element(index);
    }

    @Override
    public UnknownTypeJsonAccessor property(String propertyName) {
        return this.asObject().property(propertyName);
    }
}

