/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.gson.impl;

import com.google.gson.JsonElement;
import org.hibernate.search.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.elasticsearch.gson.impl.RootJsonAccessor;

abstract class NonRootJsonAccessor<P extends JsonElement, T>
implements JsonAccessor<T> {
    private final JsonAccessor<P> parentAccessor;

    public NonRootJsonAccessor(JsonAccessor<P> parentAccessor) {
        this.parentAccessor = parentAccessor;
    }

    protected JsonAccessor<P> getParentAccessor() {
        return this.parentAccessor;
    }

    public String toString() {
        StringBuilder path = new StringBuilder();
        if (this.parentAccessor != RootJsonAccessor.INSTANCE) {
            path.append(this.parentAccessor.toString());
        }
        this.appendRuntimeRelativePath(path);
        return path.toString();
    }

    protected abstract void appendRuntimeRelativePath(StringBuilder var1);

    @Override
    public String getStaticAbsolutePath() {
        boolean isFirst;
        StringBuilder path = new StringBuilder();
        if (this.parentAccessor == RootJsonAccessor.INSTANCE) {
            isFirst = true;
        } else {
            isFirst = false;
            path.append(this.parentAccessor.getStaticAbsolutePath());
        }
        this.appendStaticRelativePath(path, isFirst);
        return path.toString();
    }

    protected abstract void appendStaticRelativePath(StringBuilder var1, boolean var2);
}

