/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.work.impl;

import com.google.gson.JsonObject;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.search.elasticsearch.client.impl.ElasticsearchRequest;
import org.hibernate.search.elasticsearch.client.impl.ElasticsearchResponse;
import org.hibernate.search.elasticsearch.client.impl.Paths;
import org.hibernate.search.elasticsearch.client.impl.URLEncodedString;
import org.hibernate.search.elasticsearch.gson.impl.GsonProvider;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.elasticsearch.util.impl.ElasticsearchClientUtils;
import org.hibernate.search.elasticsearch.work.impl.DefaultElasticsearchRequestSuccessAssessor;
import org.hibernate.search.elasticsearch.work.impl.ElasticsearchRequestSuccessAssessor;
import org.hibernate.search.elasticsearch.work.impl.ElasticsearchWork;
import org.hibernate.search.elasticsearch.work.impl.ElasticsearchWorkExecutionContext;
import org.hibernate.search.elasticsearch.work.impl.SimpleElasticsearchWork;
import org.hibernate.search.elasticsearch.work.impl.builder.DeleteByQueryWorkBuilder;
import org.hibernate.search.elasticsearch.work.impl.builder.RefreshWorkBuilder;
import org.hibernate.search.elasticsearch.work.impl.factory.ElasticsearchWorkFactory;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class ES2DeleteByQueryWork
extends SimpleElasticsearchWork<Void> {
    private final ElasticsearchWork<?> refreshWork;

    protected ES2DeleteByQueryWork(Builder builder) {
        super(builder);
        this.refreshWork = builder.buildRefreshWork();
    }

    @Override
    protected void beforeExecute(ElasticsearchWorkExecutionContext executionContext, ElasticsearchRequest request) {
        this.refreshWork.execute(executionContext);
    }

    @Override
    protected Void generateResult(ElasticsearchWorkExecutionContext context, ElasticsearchResponse response) {
        return null;
    }

    private static class SuccessAssessor
    implements ElasticsearchRequestSuccessAssessor {
        private static final Log LOG = (Log)LoggerFactory.make(Log.class);
        private static final int NOT_FOUND_HTTP_STATUS_CODE = 404;
        public static final SuccessAssessor INSTANCE = new SuccessAssessor();
        private final DefaultElasticsearchRequestSuccessAssessor delegate = DefaultElasticsearchRequestSuccessAssessor.builder().ignoreErrorStatuses(404).build();

        private SuccessAssessor() {
        }

        @Override
        public void checkSuccess(ElasticsearchWorkExecutionContext context, ElasticsearchRequest request, ElasticsearchResponse response) throws SearchException {
            this.delegate.checkSuccess(context, request, response);
            if (response.getStatusCode() == 404) {
                GsonProvider gsonProvider = context.getGsonProvider();
                throw LOG.elasticsearch2RequestDeleteByQueryNotFound(ElasticsearchClientUtils.formatRequest(gsonProvider, request), ElasticsearchClientUtils.formatResponse(gsonProvider, response));
            }
        }

        @Override
        public boolean isSuccess(ElasticsearchWorkExecutionContext context, JsonObject bulkResponseItem) {
            throw new AssertionFailure("This method should never be called, because DeleteByQuery actions are not Bulkable");
        }
    }

    public static class Builder
    extends SimpleElasticsearchWork.Builder<Builder>
    implements DeleteByQueryWorkBuilder {
        private final URLEncodedString indexName;
        private final JsonObject payload;
        private final Set<URLEncodedString> typeNames = new HashSet<URLEncodedString>();
        private final RefreshWorkBuilder refreshWorkBuilder;

        public Builder(URLEncodedString indexName, JsonObject payload, ElasticsearchWorkFactory workFactory) {
            super(indexName, SuccessAssessor.INSTANCE);
            this.indexName = indexName;
            this.payload = payload;
            this.refreshWorkBuilder = workFactory.refresh().index(indexName);
        }

        @Override
        public Builder type(URLEncodedString typeName) {
            this.typeNames.add(typeName);
            return this;
        }

        @Override
        protected ElasticsearchRequest buildRequest() {
            ElasticsearchRequest.Builder builder = ElasticsearchRequest.delete().pathComponent(this.indexName);
            if (!this.typeNames.isEmpty()) {
                builder.multiValuedPathComponent(this.typeNames);
            }
            builder.pathComponent(Paths._QUERY).body(this.payload);
            return builder.build();
        }

        protected ElasticsearchWork<?> buildRefreshWork() {
            return this.refreshWorkBuilder.build();
        }

        @Override
        public ES2DeleteByQueryWork build() {
            return new ES2DeleteByQueryWork(this);
        }
    }
}

