/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.eventlogger;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.time.Instant;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.marshall.SerializeWith;
import org.infinispan.util.logging.events.EventLog;
import org.infinispan.util.logging.events.EventLogCategory;
import org.infinispan.util.logging.events.EventLogLevel;

@SerializeWith(value=Externalizer.class)
public class ServerEventImpl
implements EventLog {
    private final EventLogLevel level;
    private final EventLogCategory category;
    private final Instant when;
    private final String message;
    private final Optional<String> detail;
    private final Optional<String> context;
    private final Optional<String> who;
    private final Optional<String> scope;

    ServerEventImpl(EventLogLevel level, EventLogCategory category, Instant when, String message, Optional<String> detail, Optional<String> context, Optional<String> who, Optional<String> scope) {
        this.level = level;
        this.category = category;
        this.message = message;
        this.when = when;
        this.detail = detail;
        this.context = context;
        this.who = who;
        this.scope = scope;
    }

    ServerEventImpl(EventLogLevel level, EventLogCategory category, Instant when, String message) {
        this(level, category, when, message, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    public Instant getWhen() {
        return this.when;
    }

    public EventLogLevel getLevel() {
        return this.level;
    }

    public EventLogCategory getCategory() {
        return this.category;
    }

    public String getMessage() {
        return this.message;
    }

    public Optional<String> getDetail() {
        return this.detail;
    }

    public Optional<String> getWho() {
        return this.who;
    }

    public Optional<String> getContext() {
        return this.context;
    }

    public Optional<String> getScope() {
        return this.scope;
    }

    public int compareTo(EventLog that) {
        return that.getWhen().compareTo(this.when);
    }

    public String toString() {
        return "ServerEventImpl{level=" + this.level + ", category=" + this.category + ", when=" + this.when + ", message='" + this.message + '\'' + ", detail=" + this.detail + ", context=" + this.context + ", who=" + this.who + ", scope=" + this.scope + '}';
    }

    public static class Externalizer
    extends AbstractExternalizer<ServerEventImpl> {
        public void writeObject(ObjectOutput oo, ServerEventImpl event) throws IOException {
            oo.writeObject(event.level);
            oo.writeObject(event.category);
            oo.writeObject(event.when);
            oo.writeUTF(event.message);
            oo.writeObject(event.detail);
            oo.writeObject(event.context);
            oo.writeObject(event.who);
            oo.writeObject(event.scope);
        }

        public ServerEventImpl readObject(ObjectInput oi) throws IOException, ClassNotFoundException {
            EventLogLevel level = (EventLogLevel)oi.readObject();
            EventLogCategory category = (EventLogCategory)oi.readObject();
            Instant when = (Instant)oi.readObject();
            String message = oi.readUTF();
            Optional detail = (Optional)oi.readObject();
            Optional context = (Optional)oi.readObject();
            Optional who = (Optional)oi.readObject();
            Optional scope = (Optional)oi.readObject();
            return new ServerEventImpl(level, category, when, message, detail, context, who, scope);
        }

        public Set<Class<? extends ServerEventImpl>> getTypeClasses() {
            return Collections.singleton(ServerEventImpl.class);
        }
    }
}

