/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.servlet;

import java.security.AccessController;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.security.GetContextClassLoaderAction;

public class ServletContextService
implements Service {
    private final Map<ClassLoader, ServletContext> servletContexts = new ConcurrentHashMap<ClassLoader, ServletContext>();

    void contextInitialized(ServletContext context) {
        ClassLoader cl = this.getContextClassLoader();
        if (cl != null) {
            this.servletContexts.put(cl, context);
        }
    }

    public ServletContext getCurrentServletContext() {
        ClassLoader cl = this.getContextClassLoader();
        if (cl == null) {
            return null;
        }
        return this.servletContexts.get(cl);
    }

    private ClassLoader getContextClassLoader() {
        if (System.getSecurityManager() == null) {
            return GetContextClassLoaderAction.INSTANCE.run();
        }
        return AccessController.doPrivileged(GetContextClassLoaderAction.INSTANCE);
    }

    public void cleanup() {
        this.servletContexts.clear();
    }

    public String toString() {
        return "ServletContextService [" + this.servletContexts + "]";
    }
}

