/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.server.ListenerRegistry;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceBuilder;
import org.wildfly.extension.undertow.HttpListenerAdd;
import org.wildfly.extension.undertow.HttpListenerService;
import org.wildfly.extension.undertow.HttpsListenerResourceDefinition;
import org.wildfly.extension.undertow.HttpsListenerService;
import org.wildfly.extension.undertow.ListenerAdd;
import org.wildfly.extension.undertow.ListenerService;
import org.xnio.OptionMap;

public class HttpsListenerAdd
extends ListenerAdd {
    HttpsListenerAdd(HttpsListenerResourceDefinition def) {
        super(def);
    }

    @Override
    ListenerService<? extends ListenerService> createService(String name, String serverName, OperationContext context, ModelNode model, OptionMap listenerOptions, OptionMap socketOptions) throws OperationFailedException {
        OptionMap.Builder builder = OptionMap.builder().addAll(socketOptions);
        HttpsListenerResourceDefinition.VERIFY_CLIENT.resolveOption((ExpressionResolver)context, model, builder);
        ModelNode value = HttpsListenerResourceDefinition.ENABLED_CIPHER_SUITES.resolveModelAttribute(context, model);
        String cipherSuites = value.isDefined() ? value.asString() : null;
        HttpsListenerResourceDefinition.ENABLED_PROTOCOLS.resolveOption((ExpressionResolver)context, model, builder);
        HttpsListenerResourceDefinition.SSL_SESSION_CACHE_SIZE.resolveOption((ExpressionResolver)context, model, builder);
        HttpsListenerResourceDefinition.SSL_SESSION_TIMEOUT.resolveOption((ExpressionResolver)context, model, builder);
        OptionMap.Builder listenerBuilder = OptionMap.builder().addAll(listenerOptions);
        HttpsListenerResourceDefinition.ENABLE_HTTP2.resolveOption((ExpressionResolver)context, model, listenerBuilder);
        HttpListenerAdd.handleHttp2Options(context, model, listenerBuilder);
        return new HttpsListenerService(name, serverName, listenerBuilder.getMap(), cipherSuites, builder.getMap());
    }

    @Override
    void configureAdditionalDependencies(OperationContext context, ServiceBuilder<? extends ListenerService> serviceBuilder, ModelNode model, ListenerService service) throws OperationFailedException {
        serviceBuilder.addDependency(HttpListenerAdd.REGISTRY_SERVICE_NAME, ListenerRegistry.class, ((HttpListenerService)service).getHttpListenerRegistry());
        String securityRealm = HttpsListenerResourceDefinition.SECURITY_REALM.resolveModelAttribute(context, model).asString();
        SecurityRealm.ServiceUtil.addDependency(serviceBuilder, ((HttpsListenerService)service).getSecurityRealm(), (String)securityRealm, (boolean)false);
    }
}

