/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.jgroups.subsystem;

import org.infinispan.server.commons.dmr.ModelNodes;
import org.infinispan.server.commons.naming.BinderServiceBuilder;
import org.infinispan.server.jgroups.logging.JGroupsLogger;
import org.infinispan.server.jgroups.spi.ChannelFactory;
import org.infinispan.server.jgroups.spi.ProtocolConfiguration;
import org.infinispan.server.jgroups.spi.service.ProtocolStackServiceName;
import org.infinispan.server.jgroups.subsystem.AbstractProtocolConfigurationBuilder;
import org.infinispan.server.jgroups.subsystem.JChannelFactoryBuilder;
import org.infinispan.server.jgroups.subsystem.JGroupsBindingFactory;
import org.infinispan.server.jgroups.subsystem.ProtocolConfigurationBuilder;
import org.infinispan.server.jgroups.subsystem.ProtocolResourceDefinition;
import org.infinispan.server.jgroups.subsystem.RelayConfigurationBuilder;
import org.infinispan.server.jgroups.subsystem.RelayResourceDefinition;
import org.infinispan.server.jgroups.subsystem.RemoteSiteConfigurationBuilder;
import org.infinispan.server.jgroups.subsystem.RemoteSiteResourceDefinition;
import org.infinispan.server.jgroups.subsystem.SaslConfigurationBuilder;
import org.infinispan.server.jgroups.subsystem.SaslResourceDefinition;
import org.infinispan.server.jgroups.subsystem.ThreadPoolResourceDefinition;
import org.infinispan.server.jgroups.subsystem.TransportConfigurationBuilder;
import org.infinispan.server.jgroups.subsystem.TransportResourceDefinition;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.service.ServiceTarget;

public class StackAddHandler
extends AbstractAddStepHandler {
    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        StackAddHandler.installRuntimeServices(context, operation, Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS)));
    }

    static void installRuntimeServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        String name = context.getCurrentAddressValue();
        if (!model.hasDefined(TransportResourceDefinition.WILDCARD_PATH.getKey())) {
            throw JGroupsLogger.ROOT_LOGGER.transportNotDefined(name);
        }
        ServiceTarget target = context.getServiceTarget();
        Property property = model.get(TransportResourceDefinition.WILDCARD_PATH.getKey()).asProperty();
        String type = property.getName();
        ModelNode transport = property.getValue();
        String machine = ModelNodes.asString((ModelNode)TransportResourceDefinition.MACHINE.resolveModelAttribute(context, transport));
        String rack = ModelNodes.asString((ModelNode)TransportResourceDefinition.RACK.resolveModelAttribute(context, transport));
        String site = ModelNodes.asString((ModelNode)TransportResourceDefinition.SITE.resolveModelAttribute(context, transport));
        JChannelFactoryBuilder builder = new JChannelFactoryBuilder(name);
        TransportConfigurationBuilder transportBuilder = builder.setTransport(type).setModule(ModelNodes.asModuleIdentifier((ModelNode)ProtocolResourceDefinition.MODULE.resolveModelAttribute(context, transport))).setShared(TransportResourceDefinition.SHARED.resolveModelAttribute(context, transport).asBoolean()).setTopology(site, rack, machine).setSocketBinding(ModelNodes.asString((ModelNode)ProtocolResourceDefinition.SOCKET_BINDING.resolveModelAttribute(context, transport))).setDiagnosticsSocket(ModelNodes.asString((ModelNode)TransportResourceDefinition.DIAGNOSTICS_SOCKET_BINDING.resolveModelAttribute(context, transport)));
        StackAddHandler.addProtocolProperties(context, transport, transportBuilder);
        StackAddHandler.addThreadPoolConfigurationProperties(ThreadPoolResourceDefinition.DEFAULT, "thread_pool", context, transport, transportBuilder);
        transportBuilder.build(target).install();
        if (model.hasDefined(RelayResourceDefinition.PATH.getKey())) {
            ModelNode relay = model.get(RelayResourceDefinition.PATH.getKeyValuePair());
            String siteName = RelayResourceDefinition.SITE.resolveModelAttribute(context, relay).asString();
            RelayConfigurationBuilder relayBuilder = builder.setRelay(siteName);
            if (relay.hasDefined(RemoteSiteResourceDefinition.WILDCARD_PATH.getKey())) {
                for (Property remoteSiteProperty : relay.get(RemoteSiteResourceDefinition.WILDCARD_PATH.getKey()).asPropertyList()) {
                    String remoteSiteName = remoteSiteProperty.getName();
                    String channelName = RemoteSiteResourceDefinition.CHANNEL.resolveModelAttribute(context, remoteSiteProperty.getValue()).asString();
                    relayBuilder.addRemoteSite(remoteSiteName, channelName).build(target).install();
                }
            }
            StackAddHandler.addProtocolProperties(context, relay, relayBuilder).build(target).install();
        }
        if (model.hasDefined(SaslResourceDefinition.PATH.getKey())) {
            ModelNode sasl = model.get(SaslResourceDefinition.PATH.getKeyValuePair());
            String mech = SaslResourceDefinition.MECH.resolveModelAttribute(context, sasl).asString();
            String securityRealm = SaslResourceDefinition.SECURITY_REALM.resolveModelAttribute(context, sasl).asString();
            SaslConfigurationBuilder saslBuilder = builder.setSasl(mech, securityRealm);
            ModelNode resolvedValue = SaslResourceDefinition.CLUSTER_ROLE.resolveModelAttribute(context, sasl);
            String clusterRole = resolvedValue.isDefined() ? resolvedValue.asString() : null;
            saslBuilder.setClusterRole(clusterRole);
            StackAddHandler.addProtocolProperties(context, sasl, saslBuilder).build(target).install();
        }
        if (model.hasDefined(ProtocolResourceDefinition.WILDCARD_PATH.getKey())) {
            for (Property protocolProperty : model.get(ProtocolResourceDefinition.WILDCARD_PATH.getKey()).asPropertyList()) {
                ModelNode protocol = protocolProperty.getValue();
                ProtocolConfigurationBuilder protocolBuilder = builder.addProtocol(protocolProperty.getName()).setModule(ModelNodes.asModuleIdentifier((ModelNode)ProtocolResourceDefinition.MODULE.resolveModelAttribute(context, protocol))).setSocketBinding(ModelNodes.asString((ModelNode)ProtocolResourceDefinition.SOCKET_BINDING.resolveModelAttribute(context, protocol)));
                StackAddHandler.addProtocolProperties(context, protocol, protocolBuilder).build(target).install();
            }
        }
        builder.build(target).install();
        new BinderServiceBuilder(JGroupsBindingFactory.createChannelFactoryBinding(name), ProtocolStackServiceName.CHANNEL_FACTORY.getServiceName(name), ChannelFactory.class).build(target).install();
    }

    static void removeRuntimeServices(OperationContext context, ModelNode operation, ModelNode model) {
        String name = context.getCurrentAddressValue();
        context.removeService(JGroupsBindingFactory.createChannelFactoryBinding(name).getBinderServiceName());
        context.removeService(ProtocolStackServiceName.CHANNEL_FACTORY.getServiceName(name));
        Property transport = model.get(TransportResourceDefinition.WILDCARD_PATH.getKey()).asProperty();
        context.removeService(new TransportConfigurationBuilder(name, transport.getName()).getServiceName());
        if (model.hasDefined(ProtocolResourceDefinition.WILDCARD_PATH.getKey())) {
            for (Property protocol : model.get(ProtocolResourceDefinition.WILDCARD_PATH.getKey()).asPropertyList()) {
                context.removeService(new ProtocolConfigurationBuilder(name, protocol.getName()).getServiceName());
            }
        }
        if (model.hasDefined(RelayResourceDefinition.PATH.getKey())) {
            context.removeService(new RelayConfigurationBuilder(name).getServiceName());
            ModelNode relay = model.get(RelayResourceDefinition.PATH.getKeyValuePair());
            if (relay.hasDefined(RemoteSiteResourceDefinition.WILDCARD_PATH.getKey())) {
                for (Property remoteSite : relay.get(RemoteSiteResourceDefinition.WILDCARD_PATH.getKey()).asPropertyList()) {
                    context.removeService(new RemoteSiteConfigurationBuilder(name, remoteSite.getName()).getServiceName());
                }
            }
        }
        if (model.hasDefined(SaslResourceDefinition.PATH.getKey())) {
            context.removeService(new SaslConfigurationBuilder(name).getServiceName());
        }
    }

    static <C extends ProtocolConfiguration, B extends AbstractProtocolConfigurationBuilder<C>> B addProtocolProperties(OperationContext context, ModelNode protocol, B builder) throws OperationFailedException {
        if (protocol.hasDefined(ProtocolResourceDefinition.PROPERTIES.getName())) {
            for (Property property : ProtocolResourceDefinition.PROPERTIES.resolveModelAttribute(context, protocol).asPropertyList()) {
                builder.addProperty(property.getName(), property.getValue().asString());
            }
        }
        return builder;
    }

    static <C extends ProtocolConfiguration, B extends AbstractProtocolConfigurationBuilder<C>> B addThreadPoolConfigurationProperties(ThreadPoolResourceDefinition pool, String propertyPrefix, OperationContext context, ModelNode transport, B builder) throws OperationFailedException {
        ModelNode threadModel = transport.get(pool.getPathElement().getKeyValuePair());
        builder.addProperty(propertyPrefix + ".min_threads", pool.getMinThreads().resolveModelAttribute(context, threadModel).asString()).addProperty(propertyPrefix + ".max_threads", pool.getMaxThreads().resolveModelAttribute(context, threadModel).asString());
        long keepaliveTime = pool.getKeepaliveTime().resolveModelAttribute(context, threadModel).asLong();
        builder.addProperty(propertyPrefix + ".keep_alive_time", String.valueOf(keepaliveTime));
        return builder;
    }
}

