/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.atomic.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.Function;
import org.infinispan.Cache;
import org.infinispan.atomic.AtomicMap;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.util.FastCopyHashMap;
import org.infinispan.commons.util.Util;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.FunctionalMap;
import org.infinispan.functional.MetaParam;
import org.infinispan.functional.impl.FunctionalMapImpl;
import org.infinispan.functional.impl.ReadWriteMapImpl;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class AtomicMapProxyImpl<K, V, MK>
implements AtomicMap<K, V> {
    private static final EF[] FUNCTIONS = EF.values();
    private static Log log = LogFactory.getLog(AtomicMap.class);
    private final Cache<MK, Object> cache;
    private final FunctionalMap.ReadWriteMap<MK, Object> rw;
    private final MK key;

    public AtomicMapProxyImpl(Cache<MK, Object> cache, FunctionalMap.ReadWriteMap<MK, Object> rw, MK key) {
        this.cache = cache;
        this.rw = rw;
        this.key = key;
    }

    public static <K, V, MK> AtomicMap<K, V> newInstance(Cache<MK, Object> cache, MK key, boolean createIfAbsent) {
        FunctionalMapImpl<MK, Object> fmap = FunctionalMapImpl.create(cache.getAdvancedCache());
        FunctionalMap.ReadWriteMap<MK, Object> rw = ReadWriteMapImpl.create(fmap);
        Object value = cache.get(key);
        if (value != null) {
            if (value.getClass() != AtomicMapProxyImpl.dataClass()) {
                throw log.atomicMapHasWrongType(value, AtomicMapProxyImpl.dataClass());
            }
            return new AtomicMapProxyImpl<K, V, MK>(cache, rw, key);
        }
        if (createIfAbsent) {
            AtomicMapProxyImpl.wait(rw.eval(key, Touch.instance()));
            return new AtomicMapProxyImpl<K, V, MK>(cache, rw, key);
        }
        return null;
    }

    private static Class<? extends Map> dataClass() {
        return FastCopyHashMap.class;
    }

    private static <K, V> Map<K, V> dataInstance() {
        return new FastCopyHashMap();
    }

    private static <K, V> Map<K, V> dataCopy(Map<K, V> original) {
        return new FastCopyHashMap(original);
    }

    private static IllegalStateException mapDoesNotExist() {
        return log.atomicMapDoesNotExist();
    }

    private static <K, V, MK> Map<K, V> getMap(EntryView.ReadEntryView<MK, Object> view) {
        return view.find().map(Map.class::cast).orElseThrow(AtomicMapProxyImpl::mapDoesNotExist);
    }

    private static <T> T wait(CompletableFuture<? extends T> cf) {
        try {
            return cf.join();
        }
        catch (CompletionException ce) {
            Throwable e = ce.getCause();
            while (e instanceof CacheException && e.getCause() != null) {
                e = e.getCause();
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw ce;
        }
    }

    private Map<K, V> map() {
        Object value = this.cache.get(this.key);
        if (value == null) {
            throw log.atomicMapDoesNotExist();
        }
        if (value instanceof Map) {
            return (Map)value;
        }
        throw log.atomicMapHasWrongType(value, AtomicMapProxyImpl.dataClass());
    }

    @Override
    public int size() {
        return this.map().size();
    }

    @Override
    public boolean isEmpty() {
        return this.map().isEmpty();
    }

    @Override
    public boolean containsKey(Object subkey) {
        return this.map().containsKey(subkey);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map().containsValue(value);
    }

    @Override
    public V get(Object subkey) {
        return this.map().get(subkey);
    }

    @Override
    public V put(K subkey, V value) {
        return (V)AtomicMapProxyImpl.wait(this.rw.eval(this.key, new Put(subkey, value)));
    }

    @Override
    public V remove(Object subkey) {
        return (V)AtomicMapProxyImpl.wait(this.rw.eval(this.key, new Remove(subkey)));
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        AtomicMapProxyImpl.wait(this.rw.eval(this.key, new PutAll(m)));
    }

    @Override
    public void clear() {
        AtomicMapProxyImpl.wait(this.rw.eval(this.key, Clear.instance()));
    }

    @Override
    public Set<K> keySet() {
        return new KeySetView();
    }

    @Override
    public Collection<V> values() {
        return new ValuesView();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySetView();
    }

    public String toString() {
        return "AtomicMapProxyImpl{" + this.key + "}";
    }

    private class EntrySetIterator
    implements Iterator<Map.Entry<K, V>> {
        private final Iterator<Map.Entry<K, V>> iterator;
        private Map.Entry<K, V> last;

        public EntrySetIterator(Iterator<Map.Entry<K, V>> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Map.Entry<K, V> next() {
            this.last = this.iterator.next();
            return this.last;
        }

        @Override
        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException();
            }
            AtomicMapProxyImpl.wait(AtomicMapProxyImpl.this.rw.eval(AtomicMapProxyImpl.this.key, new RemoveCond(this.last.getKey(), this.last.getValue())));
        }
    }

    private class EntrySetView
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySetView() {
        }

        private Set<Map.Entry<K, V>> entrySet() {
            return AtomicMapProxyImpl.this.map().entrySet();
        }

        @Override
        public int size() {
            return AtomicMapProxyImpl.this.size();
        }

        @Override
        public boolean contains(Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)o;
                Object v = AtomicMapProxyImpl.this.get(entry.getKey());
                return Objects.equals(v, entry.getValue());
            }
            return false;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntrySetIterator(this.entrySet().iterator());
        }

        @Override
        public Object[] toArray() {
            return this.entrySet().toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.entrySet().toArray(a);
        }

        @Override
        public boolean remove(Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)o;
                return (Boolean)AtomicMapProxyImpl.wait(AtomicMapProxyImpl.this.rw.eval(AtomicMapProxyImpl.this.key, new RemoveCond(entry.getKey(), entry.getValue())));
            }
            return false;
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.entrySet().containsAll(c);
        }

        @Override
        public void clear() {
            AtomicMapProxyImpl.this.clear();
        }
    }

    private class ValuesView
    extends AbstractCollection<V> {
        private ValuesView() {
        }

        private Collection<V> values() {
            return AtomicMapProxyImpl.this.map().values();
        }

        @Override
        public int size() {
            return AtomicMapProxyImpl.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return AtomicMapProxyImpl.this.containsValue(o);
        }

        @Override
        public Iterator<V> iterator() {
            return new ValuesIterator(this.values().iterator());
        }

        @Override
        public Object[] toArray() {
            return this.values().toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.values().toArray(a);
        }

        @Override
        public boolean remove(Object o) {
            return (Boolean)AtomicMapProxyImpl.wait(AtomicMapProxyImpl.this.rw.eval(AtomicMapProxyImpl.this.key, new RemoveValue(o)));
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.values().containsAll(c);
        }

        @Override
        public void clear() {
            AtomicMapProxyImpl.this.clear();
        }

        private class ValuesIterator
        implements Iterator<V> {
            private final Iterator<V> iterator;
            private V last;

            public ValuesIterator(Iterator<V> iterator) {
                this.iterator = iterator;
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public V next() {
                this.last = this.iterator.next();
                return this.last;
            }

            @Override
            public void remove() {
                if (this.last == null) {
                    throw new IllegalStateException();
                }
                AtomicMapProxyImpl.wait(AtomicMapProxyImpl.this.rw.eval(AtomicMapProxyImpl.this.key, new RemoveValue(this.last)));
            }
        }
    }

    private class KeyIterator
    implements Iterator<K> {
        private final Iterator<K> iterator;
        private K last;

        public KeyIterator(Iterator<K> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public K next() {
            this.last = this.iterator.next();
            return this.last;
        }

        @Override
        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException();
            }
            AtomicMapProxyImpl.this.remove(this.last);
        }
    }

    private class KeySetView
    extends AbstractSet<K> {
        private KeySetView() {
        }

        private Set<K> keys() {
            return AtomicMapProxyImpl.this.map().keySet();
        }

        @Override
        public int size() {
            return AtomicMapProxyImpl.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return AtomicMapProxyImpl.this.containsKey(o);
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator(this.keys().iterator());
        }

        @Override
        public Object[] toArray() {
            return this.keys().toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.keys().toArray(a);
        }

        @Override
        public boolean remove(Object o) {
            return AtomicMapProxyImpl.this.remove(o) != null;
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.keys().containsAll(c);
        }

        @Override
        public void clear() {
            AtomicMapProxyImpl.this.clear();
        }
    }

    public static class Externalizer
    implements AdvancedExternalizer<ExternalizableFunction> {
        public Set<Class<? extends ExternalizableFunction>> getTypeClasses() {
            return Util.asSet((Object[])new Class[]{Touch.class, Put.class, Remove.class, PutAll.class, Clear.class, RemoveValue.class, RemoveCond.class});
        }

        public Integer getId() {
            return 119;
        }

        public void writeObject(ObjectOutput output, ExternalizableFunction object) throws IOException {
            output.writeByte(object.id().ordinal());
            object.writeParams(output);
        }

        public ExternalizableFunction readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            int id = input.read();
            switch (FUNCTIONS[id]) {
                case TOUCH: {
                    return Touch.instance();
                }
                case PUT: {
                    return Put.readFrom(input);
                }
                case REMOVE: {
                    return Remove.readFrom(input);
                }
                case PUT_ALL: {
                    return PutAll.readFrom(input);
                }
                case CLEAR: {
                    return Clear.instance();
                }
                case REMOVE_VALUE: {
                    return RemoveValue.readFrom(input);
                }
                case REMOVE_COND: {
                    return RemoveCond.readFrom(input);
                }
            }
            throw new IllegalArgumentException("Unknown function id " + id);
        }
    }

    private static class RemoveCond<MK>
    implements Function<EntryView.ReadWriteEntryView<MK, Object>, Boolean>,
    ExternalizableFunction {
        private final Object key;
        private final Object value;

        public static <MK> RemoveCond<MK> readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
            return new RemoveCond<MK>(input.readObject(), input.readObject());
        }

        public RemoveCond(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public Boolean apply(EntryView.ReadWriteEntryView<MK, Object> view) {
            Map map = AtomicMapProxyImpl.dataCopy(AtomicMapProxyImpl.getMap(view));
            return map.remove(this.key, this.value);
        }

        @Override
        public EF id() {
            return EF.REMOVE_COND;
        }

        @Override
        public void writeParams(ObjectOutput output) throws IOException {
            output.writeObject(this.key);
            output.writeObject(this.value);
        }
    }

    private static class RemoveValue<MK>
    implements Function<EntryView.ReadWriteEntryView<MK, Object>, Boolean>,
    ExternalizableFunction {
        private final Object value;

        public static <MK> RemoveValue<MK> readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
            return new RemoveValue<MK>(input.readObject());
        }

        public RemoveValue(Object value) {
            this.value = value;
        }

        @Override
        public Boolean apply(EntryView.ReadWriteEntryView<MK, Object> view) {
            Map map = AtomicMapProxyImpl.dataCopy(AtomicMapProxyImpl.getMap(view));
            return map.values().remove(this.value);
        }

        @Override
        public EF id() {
            return EF.REMOVE_VALUE;
        }

        @Override
        public void writeParams(ObjectOutput output) throws IOException {
            output.writeObject(this.value);
        }
    }

    private static class Clear<MK>
    implements Function<EntryView.ReadWriteEntryView<MK, Object>, Void>,
    ExternalizableFunction {
        private static final Clear INSTANCE = new Clear();

        private Clear() {
        }

        public static <MK> Clear<MK> instance() {
            return INSTANCE;
        }

        @Override
        public Void apply(EntryView.ReadWriteEntryView<MK, Object> view) {
            AtomicMapProxyImpl.getMap(view);
            view.set(AtomicMapProxyImpl.dataInstance(), new MetaParam.Writable[0]);
            return null;
        }

        @Override
        public EF id() {
            return EF.CLEAR;
        }

        @Override
        public void writeParams(ObjectOutput output) throws IOException {
        }
    }

    private static class PutAll<K, V, MK>
    implements Function<EntryView.ReadWriteEntryView<MK, Object>, Void>,
    ExternalizableFunction {
        private final Map<? extends K, ? extends V> m;

        private PutAll(Map<? extends K, ? extends V> m) {
            this.m = m;
        }

        private static <K, V, MK> PutAll<K, V, MK> readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
            return new PutAll<K, V, MK>(MarshallUtil.unmarshallMap((ObjectInput)input, HashMap::new));
        }

        @Override
        public Void apply(EntryView.ReadWriteEntryView<MK, Object> view) {
            Map copy = AtomicMapProxyImpl.dataCopy(AtomicMapProxyImpl.getMap(view));
            copy.putAll(this.m);
            view.set(copy, new MetaParam.Writable[0]);
            return null;
        }

        @Override
        public EF id() {
            return EF.PUT_ALL;
        }

        @Override
        public void writeParams(ObjectOutput output) throws IOException {
            MarshallUtil.marshallMap(this.m, (ObjectOutput)output);
        }
    }

    private static class Remove<V, MK>
    implements Function<EntryView.ReadWriteEntryView<MK, Object>, V>,
    ExternalizableFunction {
        private final Object key;

        public Remove(Object key) {
            this.key = key;
        }

        public static <V, MK> Remove<V, MK> readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
            return new Remove<V, MK>(input.readObject());
        }

        @Override
        public V apply(EntryView.ReadWriteEntryView<MK, Object> view) {
            Map copy = AtomicMapProxyImpl.dataCopy(AtomicMapProxyImpl.getMap(view));
            view.set(copy, new MetaParam.Writable[0]);
            return copy.remove(this.key);
        }

        @Override
        public EF id() {
            return EF.REMOVE;
        }

        @Override
        public void writeParams(ObjectOutput output) throws IOException {
            output.writeObject(this.key);
        }
    }

    private static class Put<K, V, MK>
    implements Function<EntryView.ReadWriteEntryView<MK, Object>, V>,
    ExternalizableFunction {
        private final K key;
        private final V value;

        public Put(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public static <K, V, MK> Put<K, V, MK> readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
            return new Put<Object, Object, MK>(input.readObject(), input.readObject());
        }

        @Override
        public V apply(EntryView.ReadWriteEntryView<MK, Object> view) {
            Map copy = AtomicMapProxyImpl.dataCopy(AtomicMapProxyImpl.getMap(view));
            view.set(copy, new MetaParam.Writable[0]);
            return copy.put(this.key, this.value);
        }

        @Override
        public EF id() {
            return EF.PUT;
        }

        @Override
        public void writeParams(ObjectOutput output) throws IOException {
            output.writeObject(this.key);
            output.writeObject(this.value);
        }
    }

    private static class Touch<MK>
    implements Function<EntryView.ReadWriteEntryView<MK, Object>, Boolean>,
    ExternalizableFunction {
        private static final Touch INSTANCE = new Touch();

        private Touch() {
        }

        public static <MK> Touch<MK> instance() {
            return INSTANCE;
        }

        @Override
        public Boolean apply(EntryView.ReadWriteEntryView<MK, Object> view) {
            if (view.find().isPresent()) {
                if (AtomicMapProxyImpl.dataClass() != view.get().getClass()) {
                    throw log.atomicMapHasWrongType(view.get(), AtomicMapProxyImpl.dataClass());
                }
                return true;
            }
            view.set(AtomicMapProxyImpl.dataInstance(), new MetaParam.Writable[0]);
            return false;
        }

        @Override
        public EF id() {
            return EF.TOUCH;
        }

        @Override
        public void writeParams(ObjectOutput output) throws IOException {
        }
    }

    private static interface ExternalizableFunction {
        public EF id();

        public void writeParams(ObjectOutput var1) throws IOException;
    }

    private static enum EF {
        TOUCH,
        PUT,
        REMOVE,
        PUT_ALL,
        CLEAR,
        REMOVE_VALUE,
        REMOVE_COND;

    }
}

