/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container;

import org.infinispan.container.InternalEntryFactory;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.ImmortalCacheEntry;
import org.infinispan.container.entries.ImmortalCacheValue;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.container.entries.L1InternalCacheEntry;
import org.infinispan.container.entries.MortalCacheEntry;
import org.infinispan.container.entries.MortalCacheValue;
import org.infinispan.container.entries.TransientCacheEntry;
import org.infinispan.container.entries.TransientCacheValue;
import org.infinispan.container.entries.TransientMortalCacheEntry;
import org.infinispan.container.entries.TransientMortalCacheValue;
import org.infinispan.container.entries.metadata.L1MetadataInternalCacheEntry;
import org.infinispan.container.entries.metadata.MetadataImmortalCacheEntry;
import org.infinispan.container.entries.metadata.MetadataImmortalCacheValue;
import org.infinispan.container.entries.metadata.MetadataMortalCacheEntry;
import org.infinispan.container.entries.metadata.MetadataMortalCacheValue;
import org.infinispan.container.entries.metadata.MetadataTransientCacheEntry;
import org.infinispan.container.entries.metadata.MetadataTransientCacheValue;
import org.infinispan.container.entries.metadata.MetadataTransientMortalCacheEntry;
import org.infinispan.container.entries.metadata.MetadataTransientMortalCacheValue;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.container.versioning.EntryVersionsMap;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.metadata.Metadata;
import org.infinispan.transaction.impl.AbstractCacheTransaction;
import org.infinispan.util.TimeService;

public class InternalEntryFactoryImpl
implements InternalEntryFactory {
    private TimeService timeService;

    @Inject
    public void injectTimeService(TimeService timeService) {
        this.timeService = timeService;
    }

    public InternalCacheEntry create(Object key, Object value, Metadata metadata) {
        long maxIdle;
        long lifespan = metadata != null ? metadata.lifespan() : -1L;
        long l = maxIdle = metadata != null ? metadata.maxIdle() : -1L;
        if (!this.isStoreMetadata(metadata, null)) {
            if (lifespan < 0L && maxIdle < 0L) {
                return new ImmortalCacheEntry(key, value);
            }
            if (lifespan > -1L && maxIdle < 0L) {
                return new MortalCacheEntry(key, value, lifespan, this.timeService.wallClockTime());
            }
            if (lifespan < 0L && maxIdle > -1L) {
                return new TransientCacheEntry(key, value, maxIdle, this.timeService.wallClockTime());
            }
            return new TransientMortalCacheEntry(key, value, maxIdle, lifespan, this.timeService.wallClockTime());
        }
        if (lifespan < 0L && maxIdle < 0L) {
            return new MetadataImmortalCacheEntry(key, value, metadata);
        }
        if (lifespan > -1L && maxIdle < 0L) {
            return new MetadataMortalCacheEntry(key, value, metadata, this.timeService.wallClockTime());
        }
        if (lifespan < 0L && maxIdle > -1L) {
            return new MetadataTransientCacheEntry(key, value, metadata, this.timeService.wallClockTime());
        }
        return new MetadataTransientMortalCacheEntry(key, value, metadata, this.timeService.wallClockTime());
    }

    public InternalCacheEntry create(CacheEntry cacheEntry) {
        return this.create(cacheEntry.getKey(), cacheEntry.getValue(), cacheEntry.getMetadata(), cacheEntry.getLifespan(), cacheEntry.getMaxIdle());
    }

    public InternalCacheEntry create(Object key, Object value, InternalCacheEntry cacheEntry) {
        return this.create(key, value, cacheEntry.getMetadata(), cacheEntry.getCreated(), cacheEntry.getLifespan(), cacheEntry.getLastUsed(), cacheEntry.getMaxIdle());
    }

    public InternalCacheEntry create(Object key, Object value, EntryVersion version, long created, long lifespan, long lastUsed, long maxIdle) {
        if (version == null) {
            if (lifespan < 0L && maxIdle < 0L) {
                return new ImmortalCacheEntry(key, value);
            }
            if (lifespan > -1L && maxIdle < 0L) {
                return new MortalCacheEntry(key, value, lifespan, created);
            }
            if (lifespan < 0L && maxIdle > -1L) {
                return new TransientCacheEntry(key, value, maxIdle, lastUsed);
            }
            return new TransientMortalCacheEntry(key, value, maxIdle, lifespan, lastUsed, created);
        }
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan).maxIdle(maxIdle).version(version).build();
        if (lifespan < 0L && maxIdle < 0L) {
            return new MetadataImmortalCacheEntry(key, value, metadata);
        }
        if (lifespan > -1L && maxIdle < 0L) {
            return new MetadataMortalCacheEntry(key, value, metadata, created);
        }
        if (lifespan < 0L && maxIdle > -1L) {
            return new MetadataTransientCacheEntry(key, value, metadata, lastUsed);
        }
        return new MetadataTransientMortalCacheEntry(key, value, metadata, lastUsed, created);
    }

    public InternalCacheEntry create(Object key, Object value, Metadata metadata, long created, long lifespan, long lastUsed, long maxIdle) {
        if (!this.isStoreMetadata(metadata, null)) {
            if (lifespan < 0L && maxIdle < 0L) {
                return new ImmortalCacheEntry(key, value);
            }
            if (lifespan > -1L && maxIdle < 0L) {
                return new MortalCacheEntry(key, value, lifespan, created);
            }
            if (lifespan < 0L && maxIdle > -1L) {
                return new TransientCacheEntry(key, value, maxIdle, lastUsed);
            }
            return new TransientMortalCacheEntry(key, value, maxIdle, lifespan, lastUsed, created);
        }
        long metaLifespan = metadata.lifespan();
        long metaMaxIdle = metadata.maxIdle();
        if (metaLifespan < 0L && metaMaxIdle < 0L) {
            return new MetadataImmortalCacheEntry(key, value, metadata);
        }
        if (metaLifespan > -1L && metaMaxIdle < 0L) {
            return new MetadataMortalCacheEntry(key, value, metadata, created);
        }
        if (metaLifespan < 0L && metaMaxIdle > -1L) {
            return new MetadataTransientCacheEntry(key, value, metadata, lastUsed);
        }
        return new MetadataTransientMortalCacheEntry(key, value, metadata, lastUsed, created);
    }

    public InternalCacheValue createValue(CacheEntry cacheEntry) {
        Metadata metadata = cacheEntry.getMetadata();
        long lifespan = cacheEntry.getLifespan();
        long maxIdle = cacheEntry.getMaxIdle();
        if (!this.isStoreMetadata(metadata, null)) {
            if (lifespan < 0L && maxIdle < 0L) {
                return new ImmortalCacheValue(cacheEntry.getValue());
            }
            if (lifespan > -1L && maxIdle < 0L) {
                return new MortalCacheValue(cacheEntry.getValue(), -1L, lifespan);
            }
            if (lifespan < 0L && maxIdle > -1L) {
                return new TransientCacheValue(cacheEntry.getValue(), maxIdle, -1L);
            }
            return new TransientMortalCacheValue(cacheEntry.getValue(), -1L, lifespan, maxIdle, -1L);
        }
        if (lifespan < 0L && maxIdle < 0L) {
            return new MetadataImmortalCacheValue(cacheEntry.getValue(), cacheEntry.getMetadata());
        }
        if (lifespan > -1L && maxIdle < 0L) {
            return new MetadataMortalCacheValue(cacheEntry.getValue(), cacheEntry.getMetadata(), -1L);
        }
        if (lifespan < 0L && maxIdle > -1L) {
            return new MetadataTransientCacheValue(cacheEntry.getValue(), cacheEntry.getMetadata(), -1L);
        }
        return new MetadataTransientMortalCacheValue(cacheEntry.getValue(), cacheEntry.getMetadata(), -1L, -1L);
    }

    public InternalCacheEntry create(Object key, Object value, Metadata metadata, long lifespan, long maxIdle) {
        if (!this.isStoreMetadata(metadata, null)) {
            if (lifespan < 0L && maxIdle < 0L) {
                return new ImmortalCacheEntry(key, value);
            }
            if (lifespan > -1L && maxIdle < 0L) {
                return new MortalCacheEntry(key, value, lifespan, this.timeService.wallClockTime());
            }
            if (lifespan < 0L && maxIdle > -1L) {
                return new TransientCacheEntry(key, value, maxIdle, this.timeService.wallClockTime());
            }
            return new TransientMortalCacheEntry(key, value, maxIdle, lifespan, this.timeService.wallClockTime());
        }
        long metaLifespan = metadata.lifespan();
        long metaMaxIdle = metadata.maxIdle();
        if (metaLifespan < 0L && metaMaxIdle < 0L) {
            return new MetadataImmortalCacheEntry(key, value, metadata);
        }
        if (metaLifespan > -1L && metaMaxIdle < 0L) {
            return new MetadataMortalCacheEntry(key, value, metadata, this.timeService.wallClockTime());
        }
        if (metaLifespan < 0L && metaMaxIdle > -1L) {
            return new MetadataTransientCacheEntry(key, value, metadata, this.timeService.wallClockTime());
        }
        return new MetadataTransientMortalCacheEntry(key, value, metadata, this.timeService.wallClockTime());
    }

    public InternalCacheEntry update(InternalCacheEntry ice, Metadata metadata) {
        if (!this.isStoreMetadata(metadata, ice)) {
            return this.updateMetadataUnawareEntry(ice, metadata.lifespan(), metadata.maxIdle());
        }
        return this.updateMetadataAwareEntry(ice, metadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalCacheEntry update(InternalCacheEntry cacheEntry, Object value, Metadata metadata) {
        InternalCacheEntry internalCacheEntry = cacheEntry;
        synchronized (internalCacheEntry) {
            cacheEntry.setValue(value);
            InternalCacheEntry original = cacheEntry;
            cacheEntry = this.update(cacheEntry, metadata);
            if (cacheEntry.getLifespan() > 0L && original == cacheEntry) {
                cacheEntry.reincarnate(this.timeService.wallClockTime());
            }
            return cacheEntry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheEntry copy(CacheEntry cacheEntry) {
        CacheEntry cacheEntry2 = cacheEntry;
        synchronized (cacheEntry2) {
            return cacheEntry.clone();
        }
    }

    public <K, V> InternalCacheEntry createL1(K key, V value, Metadata metadata) {
        if (!this.isStoreMetadata(metadata, null)) {
            return new L1InternalCacheEntry(key, value, metadata.lifespan(), this.timeService.wallClockTime());
        }
        return new L1MetadataInternalCacheEntry(key, value, metadata, this.timeService.wallClockTime());
    }

    public InternalCacheValue getValueFromCtxOrCreateNew(Object key, InvocationContext ctx) {
        EntryVersion version;
        EntryVersionsMap updatedVersions;
        CacheEntry entry = ctx.lookupEntry(key);
        if (entry instanceof InternalCacheEntry) {
            return ((InternalCacheEntry)entry).toInternalCacheValue();
        }
        if (ctx.isInTxScope() && (updatedVersions = ((AbstractCacheTransaction)((TxInvocationContext)ctx).getCacheTransaction()).getUpdatedEntryVersions()) != null && (version = (EntryVersion)updatedVersions.get(entry.getKey())) != null) {
            Metadata metadata = entry.getMetadata();
            if (metadata == null) {
                metadata = new EmbeddedMetadata.Builder().lifespan(entry.getLifespan()).maxIdle(entry.getMaxIdle()).version(version).build();
                return this.create(entry.getKey(), entry.getValue(), metadata).toInternalCacheValue();
            }
            metadata = metadata.builder().version(version).build();
            return this.create(entry.getKey(), entry.getValue(), metadata).toInternalCacheValue();
        }
        return this.create(entry).toInternalCacheValue();
    }

    private InternalCacheEntry updateMetadataUnawareEntry(InternalCacheEntry ice, long lifespan, long maxIdle) {
        if (ice instanceof ImmortalCacheEntry) {
            if (lifespan < 0L) {
                if (maxIdle < 0L) {
                    return ice;
                }
                return new TransientCacheEntry(ice.getKey(), ice.getValue(), maxIdle, this.timeService.wallClockTime());
            }
            if (maxIdle < 0L) {
                return new MortalCacheEntry(ice.getKey(), ice.getValue(), lifespan, this.timeService.wallClockTime());
            }
            long ctm = this.timeService.wallClockTime();
            return new TransientMortalCacheEntry(ice.getKey(), ice.getValue(), maxIdle, lifespan, ctm, ctm);
        }
        if (ice instanceof MortalCacheEntry) {
            if (lifespan < 0L) {
                if (maxIdle < 0L) {
                    return new ImmortalCacheEntry(ice.getKey(), ice.getValue());
                }
                return new TransientCacheEntry(ice.getKey(), ice.getValue(), maxIdle, this.timeService.wallClockTime());
            }
            if (maxIdle < 0L) {
                ((MortalCacheEntry)ice).setLifespan(lifespan);
                return ice;
            }
            long ctm = this.timeService.wallClockTime();
            return new TransientMortalCacheEntry(ice.getKey(), ice.getValue(), maxIdle, lifespan, ctm, ctm);
        }
        if (ice instanceof TransientCacheEntry) {
            if (lifespan < 0L) {
                if (maxIdle < 0L) {
                    return new ImmortalCacheEntry(ice.getKey(), ice.getValue());
                }
                ((TransientCacheEntry)ice).setMaxIdle(maxIdle);
                return ice;
            }
            if (maxIdle < 0L) {
                return new MortalCacheEntry(ice.getKey(), ice.getValue(), lifespan, this.timeService.wallClockTime());
            }
            long ctm = this.timeService.wallClockTime();
            return new TransientMortalCacheEntry(ice.getKey(), ice.getValue(), maxIdle, lifespan, ctm, ctm);
        }
        if (ice instanceof TransientMortalCacheEntry) {
            if (lifespan < 0L) {
                if (maxIdle < 0L) {
                    return new ImmortalCacheEntry(ice.getKey(), ice.getValue());
                }
                return new TransientCacheEntry(ice.getKey(), ice.getValue(), maxIdle, this.timeService.wallClockTime());
            }
            if (maxIdle < 0L) {
                return new MortalCacheEntry(ice.getKey(), ice.getValue(), lifespan, this.timeService.wallClockTime());
            }
            TransientMortalCacheEntry transientMortalEntry = (TransientMortalCacheEntry)ice;
            transientMortalEntry.setLifespan(lifespan);
            transientMortalEntry.setMaxIdle(maxIdle);
            return ice;
        }
        return ice;
    }

    private InternalCacheEntry updateMetadataAwareEntry(InternalCacheEntry ice, Metadata metadata) {
        long lifespan = metadata.lifespan();
        long maxIdle = metadata.maxIdle();
        if (ice instanceof MetadataImmortalCacheEntry) {
            if (lifespan < 0L) {
                if (maxIdle < 0L) {
                    ice.setMetadata(metadata);
                    return ice;
                }
                return new MetadataTransientCacheEntry(ice.getKey(), ice.getValue(), metadata, this.timeService.wallClockTime());
            }
            if (maxIdle < 0L) {
                return new MetadataMortalCacheEntry(ice.getKey(), ice.getValue(), metadata, this.timeService.wallClockTime());
            }
            long ctm = this.timeService.wallClockTime();
            return new MetadataTransientMortalCacheEntry(ice.getKey(), ice.getValue(), metadata, ctm, ctm);
        }
        if (ice instanceof MetadataMortalCacheEntry) {
            if (lifespan < 0L) {
                if (maxIdle < 0L) {
                    return new MetadataImmortalCacheEntry(ice.getKey(), ice.getValue(), metadata);
                }
                return new MetadataTransientCacheEntry(ice.getKey(), ice.getValue(), metadata, this.timeService.wallClockTime());
            }
            if (maxIdle < 0L) {
                ice.setMetadata(metadata);
                return ice;
            }
            long ctm = this.timeService.wallClockTime();
            return new MetadataTransientMortalCacheEntry(ice.getKey(), ice.getValue(), metadata, ctm, ctm);
        }
        if (ice instanceof MetadataTransientCacheEntry) {
            if (lifespan < 0L) {
                if (maxIdle < 0L) {
                    return new MetadataImmortalCacheEntry(ice.getKey(), ice.getValue(), metadata);
                }
                ice.setMetadata(metadata);
                return ice;
            }
            if (maxIdle < 0L) {
                return new MetadataMortalCacheEntry(ice.getKey(), ice.getValue(), metadata, this.timeService.wallClockTime());
            }
            long ctm = this.timeService.wallClockTime();
            return new MetadataTransientMortalCacheEntry(ice.getKey(), ice.getValue(), metadata, ctm, ctm);
        }
        if (ice instanceof MetadataTransientMortalCacheEntry) {
            if (lifespan < 0L) {
                if (maxIdle < 0L) {
                    return new MetadataImmortalCacheEntry(ice.getKey(), ice.getValue(), metadata);
                }
                return new MetadataTransientCacheEntry(ice.getKey(), ice.getValue(), metadata, this.timeService.wallClockTime());
            }
            if (maxIdle < 0L) {
                return new MetadataMortalCacheEntry(ice.getKey(), ice.getValue(), metadata, this.timeService.wallClockTime());
            }
            ice.setMetadata(metadata);
            return ice;
        }
        return ice;
    }

    private boolean isStoreMetadata(Metadata metadata, InternalCacheEntry ice) {
        return !(metadata == null || ice != null && !this.isEntryMetadataAware(ice) || metadata.version() == null && metadata instanceof EmbeddedMetadata);
    }

    private boolean isEntryMetadataAware(InternalCacheEntry ice) {
        return ice instanceof MetadataImmortalCacheEntry || ice instanceof MetadataMortalCacheEntry || ice instanceof MetadataTransientCacheEntry || ice instanceof MetadataTransientMortalCacheEntry;
    }
}

