/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.scattered.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.infinispan.commons.CacheException;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.RemoteMetadata;
import org.infinispan.container.versioning.SimpleClusteredVersion;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.metadata.InternalMetadata;
import org.infinispan.metadata.Metadata;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.rpc.RpcOptions;
import org.infinispan.remoting.transport.Address;
import org.infinispan.scattered.ScatteredStateProvider;
import org.infinispan.scattered.ScatteredVersionManager;
import org.infinispan.statetransfer.OutboundTransferTask;
import org.infinispan.statetransfer.StateChunk;
import org.infinispan.statetransfer.StateProviderImpl;
import org.infinispan.topology.CacheTopology;

public class ScatteredStateProviderImpl
extends StateProviderImpl
implements ScatteredStateProvider {
    protected ScatteredVersionManager svm;
    protected CountDownLatch outboundTaskLatch;
    private RpcOptions syncIgnoreLeavers;

    @Inject
    public void init(ScatteredVersionManager svm) {
        this.svm = svm;
    }

    @Override
    public void start() {
        super.start();
        this.syncIgnoreLeavers = this.rpcManager.getRpcOptionsBuilder(ResponseMode.SYNCHRONOUS_IGNORE_LEAVERS).build();
    }

    @Override
    public void onTopologyUpdate(CacheTopology cacheTopology, boolean isRebalance) {
        if (isRebalance) {
            this.replicateAndInvalidate(cacheTopology);
        }
    }

    private void replicateAndInvalidate(CacheTopology cacheTopology) {
        Address nextMember = this.getNextMember(cacheTopology);
        if (nextMember != null) {
            this.outboundTaskLatch = new CountDownLatch(1);
            HashSet<Address> otherMembers = new HashSet<Address>(cacheTopology.getActualMembers());
            Address localAddress = this.rpcManager.getAddress();
            otherMembers.remove(localAddress);
            otherMembers.remove(nextMember);
            HashSet<Integer> oldSegments = cacheTopology.getCurrentCH().getMembers().contains(localAddress) ? new HashSet<Integer>(cacheTopology.getCurrentCH().getSegmentsForOwner(localAddress)) : Collections.emptySet();
            oldSegments.retainAll(cacheTopology.getPendingCH().getSegmentsForOwner(localAddress));
            log.trace("Segments to replicate and invalidate: " + oldSegments);
            if (oldSegments.isEmpty()) {
                return;
            }
            AtomicInteger outboundInvalidations = new AtomicInteger(1);
            OutboundTransferTask outboundTransferTask = new OutboundTransferTask(nextMember, oldSegments, this.chunkSize, cacheTopology.getTopologyId(), this.keyPartitioner, task -> {
                if (outboundInvalidations.decrementAndGet() == 0) {
                    this.outboundTaskLatch.countDown();
                }
            }, chunks -> this.invalidateChunks((List<StateChunk>)chunks, (Set<Address>)otherMembers, outboundInvalidations), OutboundTransferTask::defaultMapEntryFromDataContainer, OutboundTransferTask::defaultMapEntryFromStore, this.dataContainer, this.persistenceManager, this.rpcManager, this.commandsFactory, this.entryFactory, this.timeout, this.cacheName, true, true);
            outboundTransferTask.execute(this.executorService);
            try {
                this.outboundTaskLatch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new CacheException("Interrupted waiting for entries to be pushed");
            }
        }
    }

    private void invalidateChunks(List<StateChunk> stateChunks, Set<Address> otherMembers, AtomicInteger outboundInvalidations) {
        int numEntries = stateChunks.stream().mapToInt(chunk -> chunk.getCacheEntries().size()).sum();
        if (numEntries == 0) {
            log.tracef("Nothing to invalidate", new Object[0]);
            return;
        }
        Object[] keys = new Object[numEntries];
        int[] topologyIds = new int[numEntries];
        long[] versions = new long[numEntries];
        int i = 0;
        for (StateChunk chunk2 : stateChunks) {
            for (InternalCacheEntry entry : chunk2.getCacheEntries()) {
                if (entry.getMetadata() == null || entry.getMetadata().version() == null) continue;
                keys[i] = entry.getKey();
                SimpleClusteredVersion version = (SimpleClusteredVersion)entry.getMetadata().version();
                topologyIds[i] = version.topologyId;
                versions[i] = version.version;
                ++i;
            }
        }
        if (trace) {
            log.tracef("Invalidating %d entries from segments %s", numEntries, stateChunks.stream().map(chunk -> chunk.getSegmentId()).collect(Collectors.toList()));
        }
        outboundInvalidations.incrementAndGet();
        this.rpcManager.invokeRemotelyAsync(otherMembers, this.commandsFactory.buildInvalidateVersionsCommand(keys, topologyIds, versions, true), this.syncIgnoreLeavers).whenComplete((r, t) -> {
            try {
                if (t != null) {
                    log.failedInvalidatingRemoteCache((Throwable)t);
                }
            }
            finally {
                if (outboundInvalidations.decrementAndGet() == 0) {
                    this.outboundTaskLatch.countDown();
                }
            }
        });
    }

    private Address getNextMember(CacheTopology cacheTopology) {
        Address myAddress = this.rpcManager.getAddress();
        List<Address> members = cacheTopology.getActualMembers();
        if (members.size() == 1) {
            return null;
        }
        Iterator<Address> it = members.iterator();
        while (it.hasNext()) {
            Address member = it.next();
            if (!member.equals(myAddress)) continue;
            if (it.hasNext()) {
                return it.next();
            }
            return members.get(0);
        }
        throw new IllegalStateException();
    }

    @Override
    public void startKeysTransfer(Set<Integer> segments, Address origin) {
        CacheTopology cacheTopology = this.stateConsumer.getCacheTopology();
        Address localAddress = this.rpcManager.getAddress();
        OutboundTransferTask outboundTransferTask = new OutboundTransferTask(origin, segments, this.chunkSize, cacheTopology.getTopologyId(), this.keyPartitioner, this::onTaskCompletion, list -> {}, (ice, ef) -> {
            Metadata metadata = ice.getMetadata();
            if (metadata != null && metadata.version() != null) {
                return ef.create(ice.getKey(), null, new RemoteMetadata(localAddress, metadata.version()));
            }
            return null;
        }, (me, ef) -> {
            InternalMetadata metadata = me.getMetadata();
            if (metadata != null && metadata.version() != null) {
                return ef.create(me.getKey(), null, new RemoteMetadata(localAddress, metadata.version()));
            }
            return null;
        }, this.dataContainer, this.persistenceManager, this.rpcManager, this.commandsFactory, this.entryFactory, this.timeout, this.cacheName, true, false);
        this.addTransfer(outboundTransferTask);
        outboundTransferTask.execute(this.executorService);
    }

    @Override
    public CompletableFuture<Void> confirmRevokedSegments(int topologyId) {
        return this.stateTransferLock.topologyFuture(topologyId);
    }
}

