/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.util.SmallIntSet;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.jgroups.SuspectException;
import org.infinispan.statetransfer.StateTransferLock;
import org.infinispan.stream.impl.ClusterStreamManager;
import org.infinispan.stream.impl.KeyTrackingTerminalOperation;
import org.infinispan.stream.impl.SegmentAwareOperation;
import org.infinispan.stream.impl.StreamRequestCommand;
import org.infinispan.stream.impl.TerminalOperation;
import org.infinispan.util.RangeSet;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ClusterStreamManagerImpl<K>
implements ClusterStreamManager<K> {
    protected final Map<String, RequestTracker> currentlyRunning = new ConcurrentHashMap<String, RequestTracker>();
    protected final AtomicInteger requestId = new AtomicInteger();
    protected RpcManager rpc;
    protected CommandsFactory factory;
    protected DistributionManager dm;
    protected StateTransferLock stateTransferLock;
    protected Configuration configuration;
    protected Address localAddress;
    protected static final Log log = LogFactory.getLog(ClusterStreamManagerImpl.class);

    @Inject
    public void inject(RpcManager rpc, CommandsFactory factory, DistributionManager dm, StateTransferLock stateTransferLock, Configuration configuration) {
        this.rpc = rpc;
        this.factory = factory;
        this.dm = dm;
        this.stateTransferLock = stateTransferLock;
        this.configuration = configuration;
    }

    @Start
    public void start() {
        this.localAddress = this.rpc.getAddress();
    }

    @Override
    public <R> Object remoteStreamOperation(boolean parallelDistribution, boolean parallelStream, Set<Integer> segments, Set<K> keysToInclude, Map<Integer, Set<K>> keysToExclude, boolean includeLoader, TerminalOperation<R> operation, ClusterStreamManager.ResultsCallback<R> callback, Predicate<? super R> earlyTerminatePredicate) {
        return this.commonRemoteStreamOperation(parallelDistribution, parallelStream, segments, keysToInclude, keysToExclude, includeLoader, operation, callback, StreamRequestCommand.Type.TERMINAL, earlyTerminatePredicate);
    }

    @Override
    public <R> Object remoteStreamOperationRehashAware(boolean parallelDistribution, boolean parallelStream, Set<Integer> segments, Set<K> keysToInclude, Map<Integer, Set<K>> keysToExclude, boolean includeLoader, TerminalOperation<R> operation, ClusterStreamManager.ResultsCallback<R> callback, Predicate<? super R> earlyTerminatePredicate) {
        return this.commonRemoteStreamOperation(parallelDistribution, parallelStream, segments, keysToInclude, keysToExclude, includeLoader, operation, callback, StreamRequestCommand.Type.TERMINAL_REHASH, earlyTerminatePredicate);
    }

    private <R> Object commonRemoteStreamOperation(boolean parallelDistribution, boolean parallelStream, Set<Integer> segments, Set<K> keysToInclude, Map<Integer, Set<K>> keysToExclude, boolean includeLoader, SegmentAwareOperation operation, ClusterStreamManager.ResultsCallback<R> callback, StreamRequestCommand.Type type, Predicate<? super R> earlyTerminatePredicate) {
        String id;
        Map<Address, Set<Integer>> targets = this.determineTargets(segments);
        if (!targets.isEmpty()) {
            id = this.localAddress.toString() + this.requestId.getAndIncrement();
            log.tracef("Performing remote operations %s for id %s", targets, id);
            RequestTracker<? super R> tracker = new RequestTracker<R>(callback, targets, earlyTerminatePredicate);
            this.currentlyRunning.put(id, tracker);
            if (parallelDistribution) {
                this.submitAsyncTasks(id, targets, keysToExclude, parallelStream, keysToInclude, includeLoader, type, operation);
            } else {
                for (Map.Entry<Address, Set<Integer>> targetInfo : targets.entrySet()) {
                    Set<Integer> targetSegments = targetInfo.getValue();
                    Set<K> keysExcluded = this.determineExcludedKeys(keysToExclude, targetSegments);
                    this.rpc.invokeRemotely(Collections.singleton(targetInfo.getKey()), this.factory.buildStreamRequestCommand(id, parallelStream, type, targetSegments, keysToInclude, keysExcluded, includeLoader, operation), this.rpc.getDefaultRpcOptions(true));
                }
            }
        } else {
            log.tracef("Not performing remote operation for request as no valid targets found", new Object[0]);
            id = null;
        }
        return id;
    }

    @Override
    public <R> Object remoteStreamOperation(boolean parallelDistribution, boolean parallelStream, Set<Integer> segments, Set<K> keysToInclude, Map<Integer, Set<K>> keysToExclude, boolean includeLoader, KeyTrackingTerminalOperation<K, R, ?> operation, ClusterStreamManager.ResultsCallback<Collection<R>> callback) {
        return this.commonRemoteStreamOperation(parallelDistribution, parallelStream, segments, keysToInclude, keysToExclude, includeLoader, operation, callback, StreamRequestCommand.Type.TERMINAL_KEY, null);
    }

    @Override
    public <R2> Object remoteStreamOperationRehashAware(boolean parallelDistribution, boolean parallelStream, Set<Integer> segments, Set<K> keysToInclude, Map<Integer, Set<K>> keysToExclude, boolean includeLoader, KeyTrackingTerminalOperation<K, ?, R2> operation, ClusterStreamManager.ResultsCallback<Map<K, R2>> callback) {
        String id;
        Map<Address, Set<Integer>> targets = this.determineTargets(segments);
        if (!targets.isEmpty()) {
            id = this.localAddress.toString() + "-" + this.requestId.getAndIncrement();
            log.tracef("Performing remote rehash key aware operations %s for id %s", targets, id);
            RequestTracker<Map<K, R2>> tracker = new RequestTracker<Map<K, R2>>(callback, targets, null);
            this.currentlyRunning.put(id, tracker);
            if (parallelDistribution) {
                this.submitAsyncTasks(id, targets, keysToExclude, parallelStream, keysToInclude, includeLoader, StreamRequestCommand.Type.TERMINAL_KEY_REHASH, operation);
            } else {
                for (Map.Entry<Address, Set<Integer>> targetInfo : targets.entrySet()) {
                    Address dest = targetInfo.getKey();
                    Set<Integer> targetSegments = targetInfo.getValue();
                    try {
                        Set<K> keysExcluded = this.determineExcludedKeys(keysToExclude, targetSegments);
                        log.tracef("Submitting task to %s for %s excluding keys %s", dest, id, keysExcluded);
                        Response response = this.rpc.invokeRemotely(Collections.singleton(dest), this.factory.buildStreamRequestCommand(id, parallelStream, StreamRequestCommand.Type.TERMINAL_KEY_REHASH, targetSegments, keysToInclude, keysExcluded, includeLoader, operation), this.rpc.getDefaultRpcOptions(true)).values().iterator().next();
                        if (response.isSuccessful()) continue;
                        log.tracef("Unsuccessful response for %s from %s - making segments %s suspect", id, dest, targetSegments);
                        this.receiveResponse(id, dest, true, targetSegments, null);
                    }
                    catch (Exception e) {
                        boolean wasSuspect = this.containedSuspectException(e);
                        if (!wasSuspect) {
                            log.tracef(e, "Encounted exception for %s from %s", id, dest);
                            throw e;
                        }
                        log.tracef("Exception from %s contained a SuspectException, making all segments %s suspect", dest, targetSegments);
                        this.receiveResponse(id, dest, true, targetSegments, null);
                    }
                }
            }
        } else {
            log.tracef("Not performing remote rehash key aware operation for request as no valid targets found", new Object[0]);
            id = null;
        }
        return id;
    }

    private void submitAsyncTasks(String id, Map<Address, Set<Integer>> targets, Map<Integer, Set<K>> keysToExclude, boolean parallelStream, Set<K> keysToInclude, boolean includeLoader, StreamRequestCommand.Type type, Object operation) {
        for (Map.Entry<Address, Set<Integer>> targetInfo : targets.entrySet()) {
            Set<Integer> segments = targetInfo.getValue();
            Set<K> keysExcluded = this.determineExcludedKeys(keysToExclude, segments);
            Address dest = targetInfo.getKey();
            log.tracef("Submitting async task to %s for %s excluding keys %s", dest, id, keysExcluded);
            CompletableFuture<Map<Address, Response>> completableFuture = this.rpc.invokeRemotelyAsync(Collections.singleton(dest), this.factory.buildStreamRequestCommand(id, parallelStream, type, segments, keysToInclude, keysExcluded, includeLoader, operation), this.rpc.getDefaultRpcOptions(true));
            completableFuture.whenComplete((v, e) -> {
                if (v != null) {
                    Response response = (Response)v.values().iterator().next();
                    if (!response.isSuccessful()) {
                        log.tracef("Unsuccessful response for %s from %s - making segments suspect", id, targetInfo.getKey());
                        this.receiveResponse(id, (Address)targetInfo.getKey(), true, (Set)targetInfo.getValue(), null);
                    }
                } else if (e != null) {
                    boolean wasSuspect = this.containedSuspectException((Throwable)e);
                    if (!wasSuspect) {
                        log.tracef((Throwable)e, "Encounted exception for %s from %s", id, targetInfo.getKey());
                        RequestTracker tracker = this.currentlyRunning.get(id);
                        if (tracker != null) {
                            ClusterStreamManagerImpl.markTrackerWithException(tracker, dest, e, id);
                        } else {
                            log.warnf("Unhandled remote stream exception encountered", e);
                        }
                    } else {
                        log.tracef("Exception contained a SuspectException, making all segments %s suspect", targetInfo.getValue());
                        this.receiveResponse(id, (Address)targetInfo.getKey(), true, (Set)targetInfo.getValue(), null);
                    }
                }
            });
        }
    }

    private boolean containedSuspectException(Throwable e) {
        Throwable cause = e;
        boolean wasSuspect = false;
        do {
            if (!(cause instanceof SuspectException)) continue;
            wasSuspect = true;
            break;
        } while ((cause = cause.getCause()) != null);
        return wasSuspect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void markTrackerWithException(RequestTracker<?> tracker, Address dest, Throwable e, Object uuid) {
        log.tracef("Marking tracker to have exception", new Object[0]);
        tracker.throwable = e;
        if (dest == null || tracker.lastResult(dest, null)) {
            if (uuid != null) {
                log.tracef("Tracker %s completed with exception, waking sleepers!", uuid);
            } else {
                log.trace("Tracker completed due to outside cause, waking sleepers! ");
            }
            tracker.completionLock.lock();
            try {
                tracker.completionCondition.signalAll();
            }
            finally {
                tracker.completionLock.unlock();
            }
        }
    }

    private Set<K> determineExcludedKeys(Map<Integer, Set<K>> keysToExclude, Set<Integer> segmentsToUse) {
        if (keysToExclude.isEmpty()) {
            return Collections.emptySet();
        }
        return segmentsToUse.stream().flatMap(s -> {
            Set keysForSegment = (Set)keysToExclude.get(s);
            if (keysForSegment != null) {
                return keysForSegment.stream();
            }
            return null;
        }).collect(Collectors.toSet());
    }

    private Map<Address, Set<Integer>> determineTargets(Set<Integer> segments) {
        LocalizedCacheTopology cacheTopology = this.dm.getCacheTopology();
        ConsistentHash ch = cacheTopology.getReadConsistentHash();
        if (segments == null) {
            segments = new RangeSet(ch.getNumSegments());
        }
        ConcurrentHashMap<Address, Set<Integer>> targets = new ConcurrentHashMap<Address, Set<Integer>>();
        Iterator iterator = segments.iterator();
        while (iterator.hasNext()) {
            Integer segment = (Integer)iterator.next();
            Address owner = ch.locatePrimaryOwnerForSegment(segment);
            if (owner == null) {
                try {
                    this.stateTransferLock.waitForTopology(cacheTopology.getTopologyId() + 1, this.configuration.clustering().stateTransfer().timeout(), TimeUnit.MILLISECONDS);
                    cacheTopology = this.dm.getCacheTopology();
                    ch = cacheTopology.getReadConsistentHash();
                    iterator = segments.iterator();
                    targets.clear();
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new CacheException("Stream operation was interrupted", (Throwable)e);
                }
                catch (TimeoutException e) {
                    throw new CacheException("Timed out waiting for a topology with owners for segment " + segment);
                }
            }
            if (owner.equals(this.localAddress)) continue;
            targets.computeIfAbsent(owner, t -> new SmallIntSet()).add(segment);
        }
        return targets;
    }

    @Override
    public boolean isComplete(Object id) {
        return !this.currentlyRunning.containsKey(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean awaitCompletion(Object id, long time, TimeUnit unit) throws InterruptedException {
        if (time <= 0L) {
            throw new IllegalArgumentException("Time must be greater than 0");
        }
        Objects.requireNonNull(id, "Identifier must be non null");
        log.tracef("Awaiting completion of %s", id);
        boolean completed = false;
        long target = System.nanoTime() + unit.toNanos(time);
        Throwable throwable = null;
        while (target - System.nanoTime() > 0L) {
            RequestTracker tracker = this.currentlyRunning.get(id);
            if (tracker == null) {
                completed = true;
                break;
            }
            throwable = tracker.throwable;
            if (throwable != null) break;
            tracker.completionLock.lock();
            try {
                if (!this.currentlyRunning.containsKey(id)) {
                    completed = true;
                    throwable = tracker.throwable;
                    break;
                }
                if (tracker.completionCondition.await(target - System.nanoTime(), TimeUnit.NANOSECONDS)) continue;
                throwable = tracker.throwable;
                completed = false;
                break;
            }
            finally {
                tracker.completionLock.unlock();
            }
        }
        log.tracef("Returning back to caller due to %s being completed: %s", id, completed);
        if (throwable != null) {
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new CacheException(throwable);
        }
        return completed;
    }

    @Override
    public void forgetOperation(Object id) {
        RequestTracker tracker;
        if (id != null && (tracker = this.currentlyRunning.remove(id)) != null) {
            tracker.completionLock.lock();
            try {
                tracker.completionCondition.signalAll();
            }
            finally {
                tracker.completionLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R1> boolean receiveResponse(Object id, Address origin, boolean complete, Set<Integer> missingSegments, R1 response) {
        log.tracef("Received response from %s with a completed response %s for id %s with %s suspected segments.", new Object[]{origin, complete, id, missingSegments});
        RequestTracker tracker = this.currentlyRunning.get(id);
        if (tracker != null) {
            boolean notify = false;
            RequestTracker requestTracker = tracker;
            synchronized (requestTracker) {
                if (tracker.awaitingResponse.containsKey(origin)) {
                    if (!missingSegments.isEmpty()) {
                        tracker.missingSegments(missingSegments);
                    }
                    if (complete) {
                        notify = tracker.lastResult(origin, response);
                    } else {
                        tracker.intermediateResults(origin, response);
                    }
                }
            }
            if (notify) {
                log.tracef("Marking %s as completed!", id);
                tracker.completionLock.lock();
                try {
                    this.currentlyRunning.remove(id);
                    tracker.completionCondition.signalAll();
                }
                finally {
                    tracker.completionLock.unlock();
                }
            }
            return !notify;
        }
        log.tracef("Ignoring response as we already received a completed response for %s from %s", id, origin);
        return false;
    }

    static class RequestTracker<R> {
        final ClusterStreamManager.ResultsCallback<R> callback;
        final Map<Address, Set<Integer>> awaitingResponse;
        final Lock completionLock = new ReentrantLock();
        final Condition completionCondition = this.completionLock.newCondition();
        final Predicate<? super R> earlyTerminatePredicate;
        Set<Integer> missingSegments;
        volatile Throwable throwable;

        RequestTracker(ClusterStreamManager.ResultsCallback<R> callback, Map<Address, Set<Integer>> awaitingResponse, Predicate<? super R> earlyTerminatePredicate) {
            this.callback = callback;
            this.awaitingResponse = awaitingResponse;
            this.earlyTerminatePredicate = earlyTerminatePredicate;
        }

        public void intermediateResults(Address origin, R intermediateResult) {
            this.callback.onIntermediateResult(origin, intermediateResult);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean lastResult(Address origin, R result) {
            Set<Integer> completedSegments = this.awaitingResponse.get(origin);
            if (this.missingSegments != null) {
                completedSegments.removeAll(this.missingSegments);
            }
            this.callback.onCompletion(origin, completedSegments, result);
            RequestTracker requestTracker = this;
            synchronized (requestTracker) {
                if (this.earlyTerminatePredicate != null && this.earlyTerminatePredicate.test(result)) {
                    this.awaitingResponse.clear();
                } else {
                    this.awaitingResponse.remove(origin);
                }
                return this.awaitingResponse.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void missingSegments(Set<Integer> segments) {
            RequestTracker requestTracker = this;
            synchronized (requestTracker) {
                if (this.missingSegments == null) {
                    this.missingSegments = segments;
                } else {
                    this.missingSegments.addAll(segments);
                }
            }
            this.callback.onSegmentsLost(segments);
        }
    }
}

