/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream.impl;

import java.util.DoubleSummaryStatistics;
import java.util.OptionalDouble;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.Spliterator;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleFunction;
import java.util.function.DoublePredicate;
import java.util.function.DoubleToIntFunction;
import java.util.function.DoubleToLongFunction;
import java.util.function.DoubleUnaryOperator;
import java.util.function.ObjDoubleConsumer;
import java.util.function.Supplier;
import java.util.stream.DoubleStream;
import org.infinispan.BaseCacheStream;
import org.infinispan.Cache;
import org.infinispan.CacheStream;
import org.infinispan.DoubleCacheStream;
import org.infinispan.IntCacheStream;
import org.infinispan.LongCacheStream;
import org.infinispan.stream.impl.DistributedDoubleCacheStream;
import org.infinispan.stream.impl.IntermediateCacheStream;
import org.infinispan.stream.impl.IntermediateCacheStreamSupplier;
import org.infinispan.stream.impl.IntermediateIntCacheStream;
import org.infinispan.stream.impl.IntermediateLongCacheStream;
import org.infinispan.stream.impl.IntermediateType;
import org.infinispan.stream.impl.local.LocalDoubleCacheStream;
import org.infinispan.util.function.SerializableBiConsumer;
import org.infinispan.util.function.SerializableDoubleBinaryOperator;
import org.infinispan.util.function.SerializableDoubleConsumer;
import org.infinispan.util.function.SerializableDoubleFunction;
import org.infinispan.util.function.SerializableDoublePredicate;
import org.infinispan.util.function.SerializableDoubleToIntFunction;
import org.infinispan.util.function.SerializableDoubleToLongFunction;
import org.infinispan.util.function.SerializableDoubleUnaryOperator;
import org.infinispan.util.function.SerializableObjDoubleConsumer;
import org.infinispan.util.function.SerializableSupplier;

public class IntermediateDoubleCacheStream
implements DoubleCacheStream {
    private BaseCacheStream remoteStream;
    private final IntermediateType type;
    private LocalDoubleCacheStream localDoubleStream;
    private IntermediateCacheStreamSupplier supplier;

    public IntermediateDoubleCacheStream(DistributedDoubleCacheStream remoteStream) {
        this.remoteStream = remoteStream;
        this.type = IntermediateType.DOUBLE;
        this.supplier = new IntermediateCacheStreamSupplier(this.type, remoteStream);
        this.localDoubleStream = new LocalDoubleCacheStream(this.supplier, remoteStream.parallel, remoteStream.registry);
    }

    public IntermediateDoubleCacheStream(BaseCacheStream remoteStream, IntermediateType type, LocalDoubleCacheStream localDoubleStream, IntermediateCacheStreamSupplier supplier) {
        this.remoteStream = remoteStream;
        this.type = type;
        this.localDoubleStream = localDoubleStream;
        this.supplier = supplier;
    }

    @Override
    public DoubleCacheStream sequentialDistribution() {
        this.remoteStream = this.remoteStream.sequentialDistribution();
        return this;
    }

    @Override
    public DoubleCacheStream parallelDistribution() {
        this.remoteStream = this.remoteStream.parallelDistribution();
        return this;
    }

    @Override
    public DoubleCacheStream filterKeySegments(Set<Integer> segments) {
        this.remoteStream = this.remoteStream.filterKeySegments(segments);
        return this;
    }

    @Override
    public DoubleCacheStream filterKeys(Set<?> keys) {
        this.remoteStream = this.remoteStream.filterKeys(keys);
        return this;
    }

    @Override
    public DoubleCacheStream distributedBatchSize(int batchSize) {
        this.remoteStream = this.remoteStream.distributedBatchSize(batchSize);
        return this;
    }

    @Override
    public DoubleCacheStream segmentCompletionListener(BaseCacheStream.SegmentCompletionListener listener) {
        throw new UnsupportedOperationException("Segment completion listener is only supported when no intermediate operation is provided (sorted, distinct, limit, skip)");
    }

    @Override
    public DoubleCacheStream disableRehashAware() {
        this.remoteStream = this.remoteStream.disableRehashAware();
        return this;
    }

    @Override
    public DoubleCacheStream timeout(long timeout, TimeUnit unit) {
        this.remoteStream = this.remoteStream.timeout(timeout, unit);
        return this;
    }

    @Override
    public boolean isParallel() {
        return this.localDoubleStream.isParallel();
    }

    @Override
    public DoubleCacheStream sorted() {
        this.localDoubleStream = this.localDoubleStream.sorted();
        return this;
    }

    @Override
    public DoubleCacheStream limit(long maxSize) {
        this.localDoubleStream = this.localDoubleStream.limit(maxSize);
        return this;
    }

    @Override
    public DoubleCacheStream skip(long n) {
        this.localDoubleStream = this.localDoubleStream.skip(n);
        return this;
    }

    @Override
    public DoubleCacheStream peek(DoubleConsumer action) {
        this.localDoubleStream = this.localDoubleStream.peek(action);
        return this;
    }

    @Override
    public DoubleCacheStream peek(SerializableDoubleConsumer action) {
        return this.peek((DoubleConsumer)action);
    }

    @Override
    public DoubleCacheStream distinct() {
        this.localDoubleStream = this.localDoubleStream.distinct();
        return this;
    }

    @Override
    public DoubleCacheStream filter(DoublePredicate predicate) {
        this.localDoubleStream = this.localDoubleStream.filter(predicate);
        return this;
    }

    @Override
    public DoubleCacheStream filter(SerializableDoublePredicate predicate) {
        return this.filter((DoublePredicate)predicate);
    }

    @Override
    public DoubleCacheStream map(DoubleUnaryOperator mapper) {
        this.localDoubleStream.map(mapper);
        return this;
    }

    @Override
    public DoubleCacheStream map(SerializableDoubleUnaryOperator mapper) {
        return this.map((DoubleUnaryOperator)mapper);
    }

    @Override
    public <U> CacheStream<U> mapToObj(DoubleFunction<? extends U> mapper) {
        return new IntermediateCacheStream(this.remoteStream, this.type, this.localDoubleStream.mapToObj((DoubleFunction)mapper), this.supplier);
    }

    @Override
    public <U> CacheStream<U> mapToObj(SerializableDoubleFunction<? extends U> mapper) {
        return this.mapToObj((DoubleFunction)mapper);
    }

    @Override
    public IntCacheStream mapToInt(DoubleToIntFunction mapper) {
        return new IntermediateIntCacheStream(this.remoteStream, this.type, this.localDoubleStream.mapToInt(mapper), this.supplier);
    }

    @Override
    public IntCacheStream mapToInt(SerializableDoubleToIntFunction mapper) {
        return this.mapToInt((DoubleToIntFunction)mapper);
    }

    @Override
    public LongCacheStream mapToLong(DoubleToLongFunction mapper) {
        return new IntermediateLongCacheStream(this.remoteStream, this.type, this.localDoubleStream.mapToLong(mapper), this.supplier);
    }

    @Override
    public LongCacheStream mapToLong(SerializableDoubleToLongFunction mapper) {
        return this.mapToLong((DoubleToLongFunction)mapper);
    }

    @Override
    public DoubleCacheStream flatMap(DoubleFunction<? extends DoubleStream> mapper) {
        this.localDoubleStream.flatMap((DoubleFunction)mapper);
        return this;
    }

    @Override
    public DoubleCacheStream flatMap(SerializableDoubleFunction<? extends DoubleStream> mapper) {
        return this.flatMap((DoubleFunction)mapper);
    }

    @Override
    public DoubleCacheStream parallel() {
        this.remoteStream = (BaseCacheStream)this.remoteStream.parallel();
        this.localDoubleStream = (LocalDoubleCacheStream)this.localDoubleStream.parallel();
        return this;
    }

    @Override
    public PrimitiveIterator.OfDouble iterator() {
        return this.localDoubleStream.iterator();
    }

    @Override
    public Spliterator.OfDouble spliterator() {
        return this.localDoubleStream.spliterator();
    }

    @Override
    public DoubleCacheStream sequential() {
        this.remoteStream = (BaseCacheStream)this.remoteStream.sequential();
        this.localDoubleStream = (LocalDoubleCacheStream)this.localDoubleStream.sequential();
        return this;
    }

    @Override
    public DoubleCacheStream unordered() {
        this.localDoubleStream = (LocalDoubleCacheStream)this.localDoubleStream.unordered();
        return this;
    }

    @Override
    public void forEach(DoubleConsumer action) {
        this.localDoubleStream.forEach(action);
    }

    @Override
    public void forEach(SerializableDoubleConsumer action) {
        this.forEach((DoubleConsumer)action);
    }

    @Override
    public <K, V> void forEach(ObjDoubleConsumer<Cache<K, V>> action) {
        this.localDoubleStream.forEach(action);
    }

    @Override
    public <K, V> void forEach(SerializableObjDoubleConsumer<Cache<K, V>> action) {
        this.forEach((ObjDoubleConsumer<Cache<K, V>>)action);
    }

    @Override
    public void forEachOrdered(DoubleConsumer action) {
        this.localDoubleStream.forEachOrdered(action);
    }

    @Override
    public double[] toArray() {
        return this.localDoubleStream.toArray();
    }

    @Override
    public double reduce(double identity, DoubleBinaryOperator op) {
        return this.localDoubleStream.reduce(identity, op);
    }

    @Override
    public double reduce(double identity, SerializableDoubleBinaryOperator op) {
        return this.reduce(identity, (DoubleBinaryOperator)op);
    }

    @Override
    public OptionalDouble reduce(DoubleBinaryOperator op) {
        return this.localDoubleStream.reduce(op);
    }

    @Override
    public OptionalDouble reduce(SerializableDoubleBinaryOperator op) {
        return this.reduce((DoubleBinaryOperator)op);
    }

    @Override
    public <R> R collect(Supplier<R> supplier, ObjDoubleConsumer<R> accumulator, BiConsumer<R, R> combiner) {
        return this.localDoubleStream.collect(supplier, accumulator, combiner);
    }

    @Override
    public <R> R collect(SerializableSupplier<R> supplier, SerializableObjDoubleConsumer<R> accumulator, SerializableBiConsumer<R, R> combiner) {
        return this.collect((Supplier<R>)supplier, (ObjDoubleConsumer<R>)accumulator, (BiConsumer<R, R>)combiner);
    }

    @Override
    public double sum() {
        return this.localDoubleStream.sum();
    }

    @Override
    public OptionalDouble min() {
        return this.localDoubleStream.min();
    }

    @Override
    public OptionalDouble max() {
        return this.localDoubleStream.max();
    }

    @Override
    public long count() {
        return this.localDoubleStream.count();
    }

    @Override
    public OptionalDouble average() {
        return this.localDoubleStream.average();
    }

    @Override
    public DoubleSummaryStatistics summaryStatistics() {
        return this.localDoubleStream.summaryStatistics();
    }

    @Override
    public boolean anyMatch(DoublePredicate predicate) {
        return this.localDoubleStream.anyMatch(predicate);
    }

    @Override
    public boolean anyMatch(SerializableDoublePredicate predicate) {
        return this.anyMatch((DoublePredicate)predicate);
    }

    @Override
    public boolean allMatch(DoublePredicate predicate) {
        return this.localDoubleStream.allMatch(predicate);
    }

    @Override
    public boolean allMatch(SerializableDoublePredicate predicate) {
        return this.allMatch((DoublePredicate)predicate);
    }

    @Override
    public boolean noneMatch(DoublePredicate predicate) {
        return this.localDoubleStream.noneMatch(predicate);
    }

    @Override
    public boolean noneMatch(SerializableDoublePredicate predicate) {
        return this.noneMatch((DoublePredicate)predicate);
    }

    @Override
    public OptionalDouble findFirst() {
        return this.localDoubleStream.findFirst();
    }

    @Override
    public OptionalDouble findAny() {
        return this.localDoubleStream.findAny();
    }

    @Override
    public CacheStream<Double> boxed() {
        return this.mapToObj(Double::valueOf);
    }

    @Override
    public DoubleCacheStream onClose(Runnable closeHandler) {
        this.remoteStream = (BaseCacheStream)this.remoteStream.onClose(closeHandler);
        return this;
    }

    @Override
    public void close() {
        this.localDoubleStream.close();
        this.remoteStream.close();
    }
}

