/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction.tm;

import javax.transaction.xa.XAResource;
import org.infinispan.transaction.tm.EmbeddedBaseTransactionManager;
import org.infinispan.transaction.tm.EmbeddedUserTransaction;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class EmbeddedTransactionManager
extends EmbeddedBaseTransactionManager {
    protected static final Log log = LogFactory.getLog(EmbeddedTransactionManager.class);

    private EmbeddedTransactionManager() {
    }

    public static EmbeddedTransactionManager getInstance() {
        return LazyInitializeHolder.TM_INSTANCE;
    }

    public static EmbeddedUserTransaction getUserTransaction() {
        return LazyInitializeHolder.USER_TX_INSTANCE;
    }

    public static void destroy() {
        EmbeddedTransactionManager.dissociateTransaction();
    }

    public XAResource firstEnlistedResource() {
        return this.getTransaction().firstEnlistedResource();
    }

    private static class LazyInitializeHolder {
        static final EmbeddedTransactionManager TM_INSTANCE = new EmbeddedTransactionManager();
        static final EmbeddedUserTransaction USER_TX_INSTANCE = new EmbeddedUserTransaction(TM_INSTANCE);

        private LazyInitializeHolder() {
        }
    }
}

