/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.service;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndex;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.as.service.logging.SarLogger;

final class ReflectionUtils {
    private ReflectionUtils() {
    }

    static Method getGetter(Class<?> clazz, String propertyName) {
        String getterName = "get" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
        String iserName = "is" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
        try {
            return clazz.getMethod(getterName, new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                return clazz.getMethod(iserName, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                String className = clazz.getName();
                throw SarLogger.ROOT_LOGGER.propertyMethodNotFound("Get", propertyName, className);
            }
        }
    }

    static Method getGetter(List<ClassReflectionIndex> classHierarchy, String propertyName) {
        String getterName = "get" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
        String iserName = "is" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
        for (ClassReflectionIndex classIndex : classHierarchy) {
            Iterator methods = classIndex.getMethods().iterator();
            Method method = null;
            String methodName = null;
            while (methods.hasNext()) {
                method = (Method)methods.next();
                methodName = method.getName();
                if (!getterName.equals(methodName) && !iserName.equals(methodName) || method.getParameterTypes().length != 0) continue;
                return method;
            }
        }
        String className = classHierarchy.get(0).getIndexedClass().getName();
        throw SarLogger.ROOT_LOGGER.propertyMethodNotFound("Get", propertyName, className);
    }

    static Method getSetter(List<ClassReflectionIndex> classHierarchy, String propertyName) {
        String setterName = "set" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
        for (ClassReflectionIndex classIndex : classHierarchy) {
            Iterator methods = classIndex.getMethods().iterator();
            Method method = null;
            String methodName = null;
            while (methods.hasNext()) {
                method = (Method)methods.next();
                methodName = method.getName();
                if (!setterName.equals(methodName) || method.getParameterTypes().length != 1) continue;
                return method;
            }
        }
        String className = classHierarchy.get(0).getIndexedClass().getName();
        throw SarLogger.ROOT_LOGGER.propertyMethodNotFound("Set", propertyName, className);
    }

    public static Method getMethod(Class<?> clazz, String methodName, Class<?>[] argumentList) {
        try {
            return clazz.getMethod(methodName, argumentList);
        }
        catch (NoSuchMethodException e) {
            throw SarLogger.ROOT_LOGGER.methodNotFound(methodName, ReflectionUtils.parameterList(argumentList), clazz.getName());
        }
    }

    static Method getMethod(List<ClassReflectionIndex> classHierarchy, String methodName, Class<?>[] types, boolean fail) {
        for (ClassReflectionIndex classIndex : classHierarchy) {
            Collection methods = classIndex.getMethods(methodName, (Class[])types);
            if (methods.size() != 1) continue;
            return (Method)methods.iterator().next();
        }
        if (fail) {
            String className = classHierarchy.get(0).getIndexedClass().getName();
            throw SarLogger.ROOT_LOGGER.methodNotFound(methodName, ReflectionUtils.parameterList(types), className);
        }
        return null;
    }

    static Object newInstance(Constructor<?> constructor, Object[] args) {
        try {
            return constructor.newInstance(args);
        }
        catch (Exception e) {
            throw SarLogger.ROOT_LOGGER.classNotInstantiated(e);
        }
    }

    static Class<?> getClass(String className, ClassLoader classLoader) {
        try {
            return Class.forName(className, false, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw SarLogger.ROOT_LOGGER.classNotFound(e);
        }
    }

    static List<ClassReflectionIndex> getClassHierarchy(String className, DeploymentReflectionIndex index, ClassLoader classLoader) {
        LinkedList<ClassReflectionIndex> retVal = new LinkedList<ClassReflectionIndex>();
        for (Class<?> temp = ReflectionUtils.getClass(className, classLoader); temp != null; temp = temp.getSuperclass()) {
            retVal.add(index.getClassIndex(temp));
        }
        return Collections.unmodifiableList(retVal);
    }

    private static String parameterList(Class<?>[] parameterTypes) {
        StringBuilder result = new StringBuilder();
        if (parameterTypes != null && parameterTypes.length > 0) {
            result.append(parameterTypes[0]);
            for (int i = 1; i < parameterTypes.length; ++i) {
                result.append(", ").append(parameterTypes[i]);
            }
        }
        return result.toString();
    }
}

