/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.syntax;

import org.infinispan.objectfilter.impl.syntax.PrimaryPredicateExpr;
import org.infinispan.objectfilter.impl.syntax.ValueExpr;
import org.infinispan.objectfilter.impl.syntax.Visitor;

public final class ComparisonExpr
implements PrimaryPredicateExpr {
    private final ValueExpr leftChild;
    private final ValueExpr rightChild;
    private final Type type;

    public ComparisonExpr(ValueExpr leftChild, ValueExpr rightChild, Type type) {
        this.leftChild = leftChild;
        this.rightChild = rightChild;
        this.type = type;
    }

    public ValueExpr getLeftChild() {
        return this.leftChild;
    }

    public ValueExpr getRightChild() {
        return this.rightChild;
    }

    public Type getComparisonType() {
        return this.type;
    }

    @Override
    public ValueExpr getChild() {
        return this.leftChild;
    }

    @Override
    public <T> T acceptVisitor(Visitor<?, ?> visitor) {
        return (T)visitor.visit(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComparisonExpr other = (ComparisonExpr)o;
        return this.type == other.type && this.leftChild.equals(other.leftChild) && this.rightChild.equals(other.rightChild);
    }

    public int hashCode() {
        int result = 31 * this.leftChild.hashCode() + this.rightChild.hashCode();
        return 31 * result + this.type.hashCode();
    }

    public String toString() {
        return (Object)((Object)this.type) + "(" + this.leftChild + ", " + this.rightChild + ')';
    }

    @Override
    public String toQueryString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.leftChild.toQueryString()).append(' ');
        switch (this.type) {
            case LESS: {
                sb.append('<');
                break;
            }
            case LESS_OR_EQUAL: {
                sb.append("<=");
                break;
            }
            case EQUAL: {
                sb.append('=');
                break;
            }
            case NOT_EQUAL: {
                sb.append("!=");
                break;
            }
            case GREATER_OR_EQUAL: {
                sb.append(">=");
                break;
            }
            case GREATER: {
                sb.append('>');
            }
        }
        sb.append(' ').append(this.rightChild.toQueryString());
        return sb.toString();
    }

    public static enum Type {
        LESS,
        LESS_OR_EQUAL,
        EQUAL,
        NOT_EQUAL,
        GREATER_OR_EQUAL,
        GREATER;


        public Type negate() {
            switch (this) {
                case LESS: {
                    return GREATER_OR_EQUAL;
                }
                case LESS_OR_EQUAL: {
                    return GREATER;
                }
                case EQUAL: {
                    return NOT_EQUAL;
                }
                case NOT_EQUAL: {
                    return EQUAL;
                }
                case GREATER_OR_EQUAL: {
                    return LESS;
                }
                case GREATER: {
                    return LESS_OR_EQUAL;
                }
            }
            return this;
        }

        public Type reverse() {
            switch (this) {
                case LESS: {
                    return GREATER;
                }
                case GREATER: {
                    return LESS;
                }
                case LESS_OR_EQUAL: {
                    return GREATER_OR_EQUAL;
                }
                case GREATER_OR_EQUAL: {
                    return LESS_OR_EQUAL;
                }
            }
            return this;
        }
    }
}

