/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import java.util.HashMap;
import java.util.Map;

public enum OperationStatus {
    Success(0),
    OperationNotExecuted(1),
    KeyDoesNotExist(2),
    SuccessWithPrevious(3),
    NotExecutedWithPrevious(4),
    InvalidIteration(5),
    SuccessCompat(6),
    SuccessWithPreviousCompat(7),
    NotExecutedWithPreviousCompat(8),
    InvalidMagicOrMsgId(129),
    UnknownOperation(130),
    UnknownVersion(131),
    ParseError(132),
    ServerError(133),
    OperationTimedOut(134),
    NodeSuspected(135),
    IllegalLifecycleState(136);

    private static final Map<Byte, OperationStatus> intMap;
    private final byte code;

    private OperationStatus(int code) {
        this.code = (byte)code;
    }

    public byte getCode() {
        return this.code;
    }

    public static OperationStatus fromCode(byte code) {
        return intMap.get(code);
    }

    static OperationStatus withCompatibility(OperationStatus st, boolean isCompatibilityEnabled) {
        if (isCompatibilityEnabled) {
            switch (st) {
                case Success: {
                    return SuccessCompat;
                }
                case SuccessWithPrevious: {
                    return SuccessWithPreviousCompat;
                }
                case NotExecutedWithPrevious: {
                    return NotExecutedWithPreviousCompat;
                }
            }
            return st;
        }
        return st;
    }

    static {
        intMap = new HashMap<Byte, OperationStatus>();
        for (OperationStatus status : OperationStatus.values()) {
            intMap.put(status.code, status);
        }
    }
}

