/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.batch;

import java.util.Collection;
import java.util.HashMap;
import org.hibernate.search.backend.FlushLuceneWork;
import org.hibernate.search.backend.IndexingMonitor;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.OptimizeLuceneWork;
import org.hibernate.search.backend.impl.StreamingOperationDispatcher;
import org.hibernate.search.backend.impl.TransactionalOperationDispatcher;
import org.hibernate.search.backend.spi.BatchBackend;
import org.hibernate.search.backend.spi.OperationDispatcher;
import org.hibernate.search.batchindexing.MassIndexerProgressMonitor;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.spi.IndexedTypeMap;
import org.hibernate.search.spi.IndexedTypeSet;

public class DefaultBatchBackend
implements BatchBackend {
    private final ExtendedSearchIntegrator integrator;
    private final MassIndexerProgressMonitor progressMonitor;
    private final OperationDispatcher streamingDispatcher;
    private final OperationDispatcher transactionalDispatcher;

    public DefaultBatchBackend(ExtendedSearchIntegrator integrator, MassIndexerProgressMonitor progressMonitor) {
        this.integrator = integrator;
        this.progressMonitor = progressMonitor;
        this.streamingDispatcher = new StreamingOperationDispatcher(integrator, true);
        this.transactionalDispatcher = new TransactionalOperationDispatcher(integrator);
    }

    @Override
    public void enqueueAsyncWork(LuceneWork work) throws InterruptedException {
        this.streamingDispatcher.dispatch(work, (IndexingMonitor)this.progressMonitor);
    }

    @Override
    public void awaitAsyncProcessingCompletion() {
        IndexedTypeMap<EntityIndexBinding> indexBindings = this.integrator.getIndexBindings();
        for (EntityIndexBinding indexBinding : indexBindings.values()) {
            for (IndexManager indexManager : indexBinding.getIndexManagers()) {
                indexManager.awaitAsyncProcessingCompletion();
            }
        }
    }

    @Override
    public void doWorkInSync(LuceneWork work) {
        this.transactionalDispatcher.dispatch(work, (IndexingMonitor)this.progressMonitor);
    }

    @Override
    public void flush(IndexedTypeSet entityTypes) {
        Collection<IndexManager> uniqueIndexManagers = this.uniqueIndexManagerForTypes(entityTypes);
        for (IndexManager indexManager : uniqueIndexManagers) {
            indexManager.performStreamOperation(FlushLuceneWork.INSTANCE, this.progressMonitor, false);
        }
    }

    @Override
    public void optimize(IndexedTypeSet entityTypes) {
        Collection<IndexManager> uniqueIndexManagers = this.uniqueIndexManagerForTypes(entityTypes);
        for (IndexManager indexManager : uniqueIndexManagers) {
            indexManager.performStreamOperation(OptimizeLuceneWork.INSTANCE, this.progressMonitor, false);
        }
    }

    private Collection<IndexManager> uniqueIndexManagerForTypes(IndexedTypeSet entityTypes) {
        HashMap<String, IndexManager> uniqueBackends = new HashMap<String, IndexManager>(entityTypes.size());
        for (IndexedTypeIdentifier type : entityTypes) {
            IndexManager[] indexManagers;
            EntityIndexBinding indexBindingForEntity = this.integrator.getIndexBinding(type);
            if (indexBindingForEntity == null) continue;
            for (IndexManager im : indexManagers = indexBindingForEntity.getIndexManagers()) {
                uniqueBackends.put(im.getIndexName(), im);
            }
        }
        return uniqueBackends.values();
    }
}

