/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.endpoint.deployments;

import org.infinispan.filter.KeyValueFilterConverterFactory;
import org.infinispan.server.endpoint.EndpointLogger;
import org.infinispan.server.endpoint.deployments.AbstractNamedFactoryExtensionProcessor;
import org.infinispan.server.endpoint.subsystem.ExtensionManagerService;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;

public class KeyValueFilterConverterExtensionProcessor
extends AbstractNamedFactoryExtensionProcessor<KeyValueFilterConverterFactory> {
    public KeyValueFilterConverterExtensionProcessor(ServiceName extensionManagerServiceName) {
        super(extensionManagerServiceName);
    }

    @Override
    public AbstractNamedFactoryExtensionProcessor.AbstractExtensionManagerService<KeyValueFilterConverterFactory> createService(String name, KeyValueFilterConverterFactory instance) {
        return new KeyValueFilterConverterFactoryService(name, instance);
    }

    @Override
    public Class<KeyValueFilterConverterFactory> getServiceClass() {
        return KeyValueFilterConverterFactory.class;
    }

    private static final class KeyValueFilterConverterFactoryService
    extends AbstractNamedFactoryExtensionProcessor.AbstractExtensionManagerService<KeyValueFilterConverterFactory> {
        private KeyValueFilterConverterFactoryService(String name, KeyValueFilterConverterFactory converterFactory) {
            super(name, converterFactory);
        }

        public void start(StartContext context) {
            EndpointLogger.ROOT_LOGGER.debugf("Started key value filter converter service with name = %s", this.name);
            ((ExtensionManagerService)this.extensionManager.getValue()).addKeyValueFilterConverterFactory(this.name, (KeyValueFilterConverterFactory)this.extension);
        }

        public void stop(StopContext context) {
            EndpointLogger.ROOT_LOGGER.debugf("Stopped combined filter and converter service with name = %s", this.name);
            ((ExtensionManagerService)this.extensionManager.getValue()).removeKeyValueFilterConverterFactory(this.name);
        }

        public KeyValueFilterConverterFactory getValue() {
            return (KeyValueFilterConverterFactory)this.extension;
        }

        @Override
        public String getServiceTypeName() {
            return "key-value-filter-converter-factory";
        }
    }
}

