/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.endpoint.deployments;

import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.server.endpoint.Constants;
import org.infinispan.server.endpoint.EndpointLogger;
import org.infinispan.server.endpoint.deployments.AbstractServerExtensionProcessor;
import org.infinispan.server.endpoint.subsystem.ExtensionManagerService;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class MarshallerExtensionProcessor
extends AbstractServerExtensionProcessor<Marshaller> {
    private final ServiceName extensionManagerServiceName;

    public MarshallerExtensionProcessor(ServiceName extensionManagerServiceName) {
        this.extensionManagerServiceName = extensionManagerServiceName;
    }

    @Override
    public Class<Marshaller> getServiceClass() {
        return Marshaller.class;
    }

    @Override
    public void installService(DeploymentPhaseContext ctx, String serviceName, Marshaller instance) {
        MarshallerService service = new MarshallerService(instance);
        ServiceName extensionServiceName = Constants.DATAGRID.append(new String[]{service.getServiceTypeName()});
        ServiceBuilder serviceBuilder = ctx.getServiceTarget().addService(extensionServiceName, (Service)service).setInitialMode(ServiceController.Mode.ACTIVE).addDependency(this.extensionManagerServiceName, ExtensionManagerService.class, service.getExtensionManager());
        try {
            serviceBuilder.install();
        }
        catch (IllegalStateException e) {
            EndpointLogger.ROOT_LOGGER.duplicateMarshallerDeployment(ctx.getDeploymentUnit().getName());
            EndpointLogger.ROOT_LOGGER.debug("Marshaller already installed", e);
        }
    }

    private static final class MarshallerService
    implements Service<Marshaller> {
        private final Marshaller marshaller;
        private final InjectedValue<ExtensionManagerService> extensionManager = new InjectedValue();

        private MarshallerService(Marshaller marshaller) {
            assert (marshaller != null) : EndpointLogger.ROOT_LOGGER.nullVar(this.getServiceTypeName());
            this.marshaller = marshaller;
        }

        InjectedValue<ExtensionManagerService> getExtensionManager() {
            return this.extensionManager;
        }

        public void start(StartContext context) throws StartException {
            EndpointLogger.ROOT_LOGGER.debugf("Started marshaller service with marshaller = %s", this.marshaller);
            ((ExtensionManagerService)this.extensionManager.getValue()).setMarshaller(this.marshaller);
        }

        public void stop(StopContext context) {
            EndpointLogger.ROOT_LOGGER.debugf("Stopped marshaller service with marshaller = %s", this.marshaller);
            ((ExtensionManagerService)this.extensionManager.getValue()).setMarshaller(null);
        }

        public Marshaller getValue() {
            return this.marshaller;
        }

        String getServiceTypeName() {
            return "remote-event-marshaller";
        }
    }
}

