/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.endpoint.subsystem;

import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.infinispan.server.commons.msc.ServiceContainerHelper;
import org.infinispan.server.core.CacheIgnoreAware;
import org.infinispan.server.endpoint.Constants;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;

public class CacheIgnoreReadWriteHandler
extends AbstractWriteAttributeHandler<Void> {
    public CacheIgnoreReadWriteHandler(AttributeDefinition attribute) {
        super(new AttributeDefinition[]{attribute});
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> handbackHolder) throws OperationFailedException {
        CacheIgnoreAware cacheIgnoreAware = this.getCacheDisablingAware(operation, context);
        this.applyModelToRuntime(cacheIgnoreAware, resolvedValue);
        return false;
    }

    private CacheIgnoreAware getCacheDisablingAware(ModelNode operation, OperationContext context) {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        PathElement lastElement = address.getLastElement();
        String connectorType = lastElement.getKey().split("-")[0];
        String connectorName = lastElement.getValue();
        ServiceName serviceName = Constants.DATAGRID.append(new String[]{connectorType, connectorName});
        ServiceController service = ServiceContainerHelper.findService((ServiceRegistry)context.getServiceRegistry(true), (ServiceName)serviceName);
        return (CacheIgnoreAware)service.getValue();
    }

    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Void handback) throws OperationFailedException {
        CacheIgnoreAware cacheIgnoreAware = this.getCacheDisablingAware(operation, context);
        ModelNode restored = context.readResource(PathAddress.EMPTY_ADDRESS).getModel().clone();
        restored.get(attributeName).set(valueToRestore);
        this.applyModelToRuntime(cacheIgnoreAware, restored);
    }

    private void applyModelToRuntime(CacheIgnoreAware cacheIgnoreAware, ModelNode model) throws OperationFailedException {
        Set values = Collections.emptySet();
        if (model.isDefined()) {
            values = model.asList().stream().map(ModelNode::asString).collect(Collectors.toSet());
        }
        cacheIgnoreAware.setIgnoredCaches(values);
    }
}

