/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.io.FilterReader;
import java.io.Reader;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;
import org.hibernate.JDBCException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.ScrollMode;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.AnsiTrimFunction;
import org.hibernate.dialect.function.NoArgSQLFunction;
import org.hibernate.dialect.function.SQLFunctionTemplate;
import org.hibernate.dialect.function.StandardSQLFunction;
import org.hibernate.dialect.function.VarArgsSQLFunction;
import org.hibernate.dialect.pagination.AbstractLimitHandler;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.pagination.LimitHelper;
import org.hibernate.engine.jdbc.CharacterStream;
import org.hibernate.engine.jdbc.ClobImplementer;
import org.hibernate.engine.jdbc.NClobImplementer;
import org.hibernate.engine.spi.RowSelection;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.exception.LockAcquisitionException;
import org.hibernate.exception.LockTimeoutException;
import org.hibernate.exception.SQLGrammarException;
import org.hibernate.exception.spi.SQLExceptionConversionDelegate;
import org.hibernate.hql.spi.id.IdTableSupportStandardImpl;
import org.hibernate.hql.spi.id.MultiTableBulkIdStrategy;
import org.hibernate.hql.spi.id.global.GlobalTemporaryTableBulkIdStrategy;
import org.hibernate.hql.spi.id.local.AfterUseAction;
import org.hibernate.internal.util.JdbcExceptionHelper;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.sql.BasicBinder;
import org.hibernate.type.descriptor.sql.BitTypeDescriptor;
import org.hibernate.type.descriptor.sql.ClobTypeDescriptor;
import org.hibernate.type.descriptor.sql.NClobTypeDescriptor;
import org.hibernate.type.descriptor.sql.SmallIntTypeDescriptor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;

public abstract class AbstractHANADialect
extends Dialect {
    private static final AbstractLimitHandler LIMIT_HANDLER = new AbstractLimitHandler(){

        @Override
        public String processSql(String sql, RowSelection selection) {
            boolean hasOffset = LimitHelper.hasFirstRow(selection);
            return sql + (hasOffset ? " limit ? offset ?" : " limit ?");
        }

        @Override
        public boolean supportsLimit() {
            return true;
        }

        @Override
        public boolean bindLimitParametersInReverseOrder() {
            return true;
        }
    };
    private static final ClobTypeDescriptor HANA_CLOB_STREAM_BINDING = new ClobTypeDescriptor(){
        private static final long serialVersionUID = -379042275442752102L;

        @Override
        public <X> BasicBinder<X> getClobBinder(final JavaTypeDescriptor<X> javaTypeDescriptor) {
            return new BasicBinder<X>(javaTypeDescriptor, this){

                @Override
                protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                    CharacterStream characterStream = javaTypeDescriptor.unwrap(value, CharacterStream.class, options);
                    if (value instanceof ClobImplementer) {
                        st.setCharacterStream(index, (Reader)new CloseSuppressingReader(characterStream.asReader()), characterStream.getLength());
                    } else {
                        st.setCharacterStream(index, characterStream.asReader(), characterStream.getLength());
                    }
                }

                @Override
                protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                    CharacterStream characterStream = javaTypeDescriptor.unwrap(value, CharacterStream.class, options);
                    if (value instanceof ClobImplementer) {
                        st.setCharacterStream(name, (Reader)new CloseSuppressingReader(characterStream.asReader()), characterStream.getLength());
                    } else {
                        st.setCharacterStream(name, characterStream.asReader(), characterStream.getLength());
                    }
                }
            };
        }
    };
    private static final NClobTypeDescriptor HANA_NCLOB_STREAM_BINDING = new NClobTypeDescriptor(){
        private static final long serialVersionUID = 5651116091681647859L;

        @Override
        public <X> BasicBinder<X> getNClobBinder(final JavaTypeDescriptor<X> javaTypeDescriptor) {
            return new BasicBinder<X>(javaTypeDescriptor, this){

                @Override
                protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                    CharacterStream characterStream = javaTypeDescriptor.unwrap(value, CharacterStream.class, options);
                    if (value instanceof NClobImplementer) {
                        st.setCharacterStream(index, (Reader)new CloseSuppressingReader(characterStream.asReader()), characterStream.getLength());
                    } else {
                        st.setCharacterStream(index, characterStream.asReader(), characterStream.getLength());
                    }
                }

                @Override
                protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                    CharacterStream characterStream = javaTypeDescriptor.unwrap(value, CharacterStream.class, options);
                    if (value instanceof NClobImplementer) {
                        st.setCharacterStream(name, (Reader)new CloseSuppressingReader(characterStream.asReader()), characterStream.getLength());
                    } else {
                        st.setCharacterStream(name, characterStream.asReader(), characterStream.getLength());
                    }
                }
            };
        }
    };

    public AbstractHANADialect() {
        this.registerColumnType(3, "decimal($p, $s)");
        this.registerColumnType(8, "double");
        this.registerColumnType(-2, 5000L, "varbinary($l)");
        this.registerColumnType(-3, 5000L, "varbinary($l)");
        this.registerColumnType(-4, 5000L, "varbinary($l)");
        this.registerColumnType(-2, "blob");
        this.registerColumnType(-3, "blob");
        this.registerColumnType(-4, "blob");
        this.registerColumnType(1, "varchar(1)");
        this.registerColumnType(12, 5000L, "varchar($l)");
        this.registerColumnType(-1, 5000L, "varchar($l)");
        this.registerColumnType(-9, 5000L, "nvarchar($l)");
        this.registerColumnType(-1, "clob");
        this.registerColumnType(12, "clob");
        this.registerColumnType(-9, "nclob");
        this.registerColumnType(2005, "clob");
        this.registerColumnType(16, "tinyint");
        this.registerColumnType(-7, "smallint");
        this.registerColumnType(-6, "smallint");
        this.registerHibernateType(2011, StandardBasicTypes.NCLOB.getName());
        this.registerHibernateType(-9, StandardBasicTypes.STRING.getName());
        this.registerFunction("to_date", new StandardSQLFunction("to_date", StandardBasicTypes.DATE));
        this.registerFunction("to_seconddate", new StandardSQLFunction("to_seconddate", StandardBasicTypes.TIMESTAMP));
        this.registerFunction("to_time", new StandardSQLFunction("to_time", StandardBasicTypes.TIME));
        this.registerFunction("to_timestamp", new StandardSQLFunction("to_timestamp", StandardBasicTypes.TIMESTAMP));
        this.registerFunction("current_date", new NoArgSQLFunction("current_date", StandardBasicTypes.DATE, false));
        this.registerFunction("current_time", new NoArgSQLFunction("current_time", StandardBasicTypes.TIME, false));
        this.registerFunction("current_timestamp", new NoArgSQLFunction("current_timestamp", StandardBasicTypes.TIMESTAMP, false));
        this.registerFunction("current_utcdate", new NoArgSQLFunction("current_utcdate", StandardBasicTypes.DATE, false));
        this.registerFunction("current_utctime", new NoArgSQLFunction("current_utctime", StandardBasicTypes.TIME, false));
        this.registerFunction("current_utctimestamp", new NoArgSQLFunction("current_utctimestamp", StandardBasicTypes.TIMESTAMP, false));
        this.registerFunction("add_days", new StandardSQLFunction("add_days"));
        this.registerFunction("add_months", new StandardSQLFunction("add_months"));
        this.registerFunction("add_seconds", new StandardSQLFunction("add_seconds"));
        this.registerFunction("add_years", new StandardSQLFunction("add_years"));
        this.registerFunction("dayname", new StandardSQLFunction("dayname", StandardBasicTypes.STRING));
        this.registerFunction("dayofmonth", new StandardSQLFunction("dayofmonth", StandardBasicTypes.INTEGER));
        this.registerFunction("dayofyear", new StandardSQLFunction("dayofyear", StandardBasicTypes.INTEGER));
        this.registerFunction("days_between", new StandardSQLFunction("days_between", StandardBasicTypes.INTEGER));
        this.registerFunction("hour", new StandardSQLFunction("hour", StandardBasicTypes.INTEGER));
        this.registerFunction("isoweek", new StandardSQLFunction("isoweek", StandardBasicTypes.STRING));
        this.registerFunction("last_day", new StandardSQLFunction("last_day", StandardBasicTypes.DATE));
        this.registerFunction("localtoutc", new StandardSQLFunction("localtoutc", StandardBasicTypes.TIMESTAMP));
        this.registerFunction("minute", new StandardSQLFunction("minute", StandardBasicTypes.INTEGER));
        this.registerFunction("month", new StandardSQLFunction("month", StandardBasicTypes.INTEGER));
        this.registerFunction("monthname", new StandardSQLFunction("monthname", StandardBasicTypes.STRING));
        this.registerFunction("next_day", new StandardSQLFunction("next_day", StandardBasicTypes.DATE));
        this.registerFunction("now", new NoArgSQLFunction("now", StandardBasicTypes.TIMESTAMP, true));
        this.registerFunction("quarter", new StandardSQLFunction("quarter", StandardBasicTypes.STRING));
        this.registerFunction("second", new StandardSQLFunction("second", StandardBasicTypes.INTEGER));
        this.registerFunction("seconds_between", new StandardSQLFunction("seconds_between", StandardBasicTypes.LONG));
        this.registerFunction("week", new StandardSQLFunction("week", StandardBasicTypes.INTEGER));
        this.registerFunction("weekday", new StandardSQLFunction("weekday", StandardBasicTypes.INTEGER));
        this.registerFunction("year", new StandardSQLFunction("year", StandardBasicTypes.INTEGER));
        this.registerFunction("utctolocal", new StandardSQLFunction("utctolocal", StandardBasicTypes.TIMESTAMP));
        this.registerFunction("to_bigint", new StandardSQLFunction("to_bigint", StandardBasicTypes.LONG));
        this.registerFunction("to_binary", new StandardSQLFunction("to_binary", StandardBasicTypes.BINARY));
        this.registerFunction("to_decimal", new StandardSQLFunction("to_decimal", StandardBasicTypes.BIG_DECIMAL));
        this.registerFunction("to_double", new StandardSQLFunction("to_double", StandardBasicTypes.DOUBLE));
        this.registerFunction("to_int", new StandardSQLFunction("to_int", StandardBasicTypes.INTEGER));
        this.registerFunction("to_integer", new StandardSQLFunction("to_integer", StandardBasicTypes.INTEGER));
        this.registerFunction("to_real", new StandardSQLFunction("to_real", StandardBasicTypes.FLOAT));
        this.registerFunction("to_smalldecimal", new StandardSQLFunction("to_smalldecimal", StandardBasicTypes.BIG_DECIMAL));
        this.registerFunction("to_smallint", new StandardSQLFunction("to_smallint", StandardBasicTypes.SHORT));
        this.registerFunction("to_tinyint", new StandardSQLFunction("to_tinyint", StandardBasicTypes.BYTE));
        this.registerFunction("abs", new StandardSQLFunction("abs"));
        this.registerFunction("acos", new StandardSQLFunction("acos", StandardBasicTypes.DOUBLE));
        this.registerFunction("asin", new StandardSQLFunction("asin", StandardBasicTypes.DOUBLE));
        this.registerFunction("atan2", new StandardSQLFunction("atan", StandardBasicTypes.DOUBLE));
        this.registerFunction("bin2hex", new StandardSQLFunction("bin2hex", StandardBasicTypes.STRING));
        this.registerFunction("bitand", new StandardSQLFunction("bitand", StandardBasicTypes.LONG));
        this.registerFunction("ceil", new StandardSQLFunction("ceil"));
        this.registerFunction("cos", new StandardSQLFunction("cos", StandardBasicTypes.DOUBLE));
        this.registerFunction("cosh", new StandardSQLFunction("cosh", StandardBasicTypes.DOUBLE));
        this.registerFunction("cot", new StandardSQLFunction("cos", StandardBasicTypes.DOUBLE));
        this.registerFunction("exp", new StandardSQLFunction("exp", StandardBasicTypes.DOUBLE));
        this.registerFunction("floor", new StandardSQLFunction("floor"));
        this.registerFunction("greatest", new StandardSQLFunction("greatest"));
        this.registerFunction("hex2bin", new StandardSQLFunction("hex2bin", StandardBasicTypes.BINARY));
        this.registerFunction("least", new StandardSQLFunction("least"));
        this.registerFunction("ln", new StandardSQLFunction("ln", StandardBasicTypes.DOUBLE));
        this.registerFunction("log", new StandardSQLFunction("ln", StandardBasicTypes.DOUBLE));
        this.registerFunction("power", new StandardSQLFunction("power"));
        this.registerFunction("round", new StandardSQLFunction("round"));
        this.registerFunction("mod", new StandardSQLFunction("mod", StandardBasicTypes.INTEGER));
        this.registerFunction("sign", new StandardSQLFunction("sign", StandardBasicTypes.INTEGER));
        this.registerFunction("sin", new StandardSQLFunction("sin", StandardBasicTypes.DOUBLE));
        this.registerFunction("sinh", new StandardSQLFunction("sinh", StandardBasicTypes.DOUBLE));
        this.registerFunction("sqrt", new StandardSQLFunction("sqrt", StandardBasicTypes.DOUBLE));
        this.registerFunction("tan", new StandardSQLFunction("tan", StandardBasicTypes.DOUBLE));
        this.registerFunction("tanh", new StandardSQLFunction("tanh", StandardBasicTypes.DOUBLE));
        this.registerFunction("uminus", new StandardSQLFunction("uminus"));
        this.registerFunction("to_alphanum", new StandardSQLFunction("to_alphanum", StandardBasicTypes.STRING));
        this.registerFunction("to_nvarchar", new StandardSQLFunction("to_nvarchar", StandardBasicTypes.STRING));
        this.registerFunction("to_varchar", new StandardSQLFunction("to_varchar", StandardBasicTypes.STRING));
        this.registerFunction("ascii", new StandardSQLFunction("ascii", StandardBasicTypes.INTEGER));
        this.registerFunction("char", new StandardSQLFunction("char", StandardBasicTypes.CHARACTER));
        this.registerFunction("concat", new VarArgsSQLFunction(StandardBasicTypes.STRING, "(", "||", ")"));
        this.registerFunction("lcase", new StandardSQLFunction("lcase", StandardBasicTypes.STRING));
        this.registerFunction("left", new StandardSQLFunction("left", StandardBasicTypes.STRING));
        this.registerFunction("length", new StandardSQLFunction("length", StandardBasicTypes.LONG));
        this.registerFunction("locate", new StandardSQLFunction("locate", StandardBasicTypes.INTEGER));
        this.registerFunction("lpad", new StandardSQLFunction("lpad", StandardBasicTypes.STRING));
        this.registerFunction("ltrim", new StandardSQLFunction("ltrim", StandardBasicTypes.STRING));
        this.registerFunction("nchar", new StandardSQLFunction("nchar", StandardBasicTypes.STRING));
        this.registerFunction("replace", new StandardSQLFunction("replace", StandardBasicTypes.STRING));
        this.registerFunction("right", new StandardSQLFunction("right", StandardBasicTypes.STRING));
        this.registerFunction("rpad", new StandardSQLFunction("rpad", StandardBasicTypes.STRING));
        this.registerFunction("rtrim", new StandardSQLFunction("rtrim", StandardBasicTypes.STRING));
        this.registerFunction("substr_after", new StandardSQLFunction("substr_after", StandardBasicTypes.STRING));
        this.registerFunction("substr_before", new StandardSQLFunction("substr_before", StandardBasicTypes.STRING));
        this.registerFunction("substring", new StandardSQLFunction("substring", StandardBasicTypes.STRING));
        this.registerFunction("trim", new AnsiTrimFunction());
        this.registerFunction("ucase", new StandardSQLFunction("ucase", StandardBasicTypes.STRING));
        this.registerFunction("unicode", new StandardSQLFunction("unicode", StandardBasicTypes.INTEGER));
        this.registerFunction("bit_length", new SQLFunctionTemplate(StandardBasicTypes.INTEGER, "length(to_binary(?1))*8"));
        this.registerFunction("to_blob", new StandardSQLFunction("to_blob", StandardBasicTypes.BLOB));
        this.registerFunction("to_clob", new StandardSQLFunction("to_clob", StandardBasicTypes.CLOB));
        this.registerFunction("to_nclob", new StandardSQLFunction("to_nclob", StandardBasicTypes.NCLOB));
        this.registerFunction("coalesce", new StandardSQLFunction("coalesce"));
        this.registerFunction("current_connection", new NoArgSQLFunction("current_connection", StandardBasicTypes.INTEGER, false));
        this.registerFunction("current_schema", new NoArgSQLFunction("current_schema", StandardBasicTypes.STRING, false));
        this.registerFunction("current_user", new NoArgSQLFunction("current_user", StandardBasicTypes.STRING, false));
        this.registerFunction("grouping_id", new VarArgsSQLFunction(StandardBasicTypes.INTEGER, "(", ",", ")"));
        this.registerFunction("ifnull", new StandardSQLFunction("ifnull"));
        this.registerFunction("map", new StandardSQLFunction("map"));
        this.registerFunction("nullif", new StandardSQLFunction("nullif"));
        this.registerFunction("session_context", new StandardSQLFunction("session_context"));
        this.registerFunction("session_user", new NoArgSQLFunction("session_user", StandardBasicTypes.STRING, false));
        this.registerFunction("sysuuid", new NoArgSQLFunction("sysuuid", StandardBasicTypes.STRING, false));
        this.registerHanaKeywords();
        this.getDefaultProperties().setProperty("hibernate.jdbc.lob.non_contextual_creation", "true");
    }

    @Override
    public boolean bindLimitParametersInReverseOrder() {
        return true;
    }

    @Override
    public SQLExceptionConversionDelegate buildSQLExceptionConversionDelegate() {
        return new SQLExceptionConversionDelegate(){

            @Override
            public JDBCException convert(SQLException sqlException, String message, String sql) {
                int errorCode = JdbcExceptionHelper.extractErrorCode(sqlException);
                if (errorCode == 131) {
                    return new LockTimeoutException(message, sqlException, sql);
                }
                if (errorCode == 146) {
                    return new LockTimeoutException(message, sqlException, sql);
                }
                if (errorCode == 132) {
                    return new LockAcquisitionException(message, sqlException, sql);
                }
                if (errorCode == 133) {
                    return new LockAcquisitionException(message, sqlException, sql);
                }
                if (errorCode == 257 || errorCode >= 259 && errorCode <= 263) {
                    throw new SQLGrammarException(message, sqlException, sql);
                }
                if (errorCode == 287 || errorCode == 301 || errorCode == 461 || errorCode == 462) {
                    String constraintName = AbstractHANADialect.this.getViolatedConstraintNameExtracter().extractConstraintName(sqlException);
                    return new ConstraintViolationException(message, sqlException, sql, constraintName);
                }
                return null;
            }
        };
    }

    @Override
    public boolean forUpdateOfColumns() {
        return true;
    }

    @Override
    public String getAddColumnString() {
        return "add (";
    }

    @Override
    public String getAddColumnSuffixString() {
        return ")";
    }

    @Override
    public String getCascadeConstraintsString() {
        return " cascade";
    }

    @Override
    public String getCreateSequenceString(String sequenceName) {
        return "create sequence " + sequenceName;
    }

    @Override
    public MultiTableBulkIdStrategy getDefaultMultiTableBulkIdStrategy() {
        return new GlobalTemporaryTableBulkIdStrategy(new IdTableSupportStandardImpl(){

            @Override
            public String getCreateIdTableCommand() {
                return "create global temporary table";
            }
        }, AfterUseAction.CLEAN);
    }

    @Override
    public String getCurrentTimestampSelectString() {
        return "select current_timestamp from dummy";
    }

    @Override
    public String getDropSequenceString(String sequenceName) {
        return "drop sequence " + sequenceName;
    }

    @Override
    public String getForUpdateString(String aliases) {
        return this.getForUpdateString() + " of " + aliases;
    }

    @Override
    public String getForUpdateString(String aliases, LockOptions lockOptions) {
        LockMode lockMode = lockOptions.getLockMode();
        Iterator itr = lockOptions.getAliasLockIterator();
        while (itr.hasNext()) {
            Map.Entry entry = (Map.Entry)itr.next();
            LockMode lm = (LockMode)((Object)entry.getValue());
            if (!lm.greaterThan(lockMode)) continue;
            lockMode = lm;
        }
        if (aliases == null || "".equals(aliases)) {
            return this.getForUpdateString(lockMode);
        }
        return this.getForUpdateString(lockMode) + " of " + aliases;
    }

    @Override
    public String getLimitString(String sql, boolean hasOffset) {
        return new StringBuilder(sql.length() + 20).append(sql).append(hasOffset ? " limit ? offset ?" : " limit ?").toString();
    }

    @Override
    public String getNotExpression(String expression) {
        return "not (" + expression + ")";
    }

    @Override
    public String getQuerySequencesString() {
        return "select sequence_name from sys.sequences";
    }

    @Override
    public String getSelectSequenceNextValString(String sequenceName) {
        return sequenceName + ".nextval";
    }

    @Override
    public String getSequenceNextValString(String sequenceName) {
        return "select " + this.getSelectSequenceNextValString(sequenceName) + " from dummy";
    }

    @Override
    protected SqlTypeDescriptor getSqlTypeDescriptorOverride(int sqlCode) {
        switch (sqlCode) {
            case 16: {
                return BitTypeDescriptor.INSTANCE;
            }
            case 2005: {
                return HANA_CLOB_STREAM_BINDING;
            }
            case 2011: {
                return HANA_NCLOB_STREAM_BINDING;
            }
            case -6: {
                return SmallIntTypeDescriptor.INSTANCE;
            }
        }
        return super.getSqlTypeDescriptorOverride(sqlCode);
    }

    @Override
    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    protected void registerHanaKeywords() {
        this.registerKeyword("all");
        this.registerKeyword("alter");
        this.registerKeyword("as");
        this.registerKeyword("before");
        this.registerKeyword("begin");
        this.registerKeyword("both");
        this.registerKeyword("case");
        this.registerKeyword("char");
        this.registerKeyword("condition");
        this.registerKeyword("connect");
        this.registerKeyword("cross");
        this.registerKeyword("cube");
        this.registerKeyword("current_connection");
        this.registerKeyword("current_date");
        this.registerKeyword("current_schema");
        this.registerKeyword("current_time");
        this.registerKeyword("current_timestamp");
        this.registerKeyword("current_user");
        this.registerKeyword("current_utcdate");
        this.registerKeyword("current_utctime");
        this.registerKeyword("current_utctimestamp");
        this.registerKeyword("currval");
        this.registerKeyword("cursor");
        this.registerKeyword("declare");
        this.registerKeyword("distinct");
        this.registerKeyword("else");
        this.registerKeyword("elseif");
        this.registerKeyword("elsif");
        this.registerKeyword("end");
        this.registerKeyword("except");
        this.registerKeyword("exception");
        this.registerKeyword("exec");
        this.registerKeyword("for");
        this.registerKeyword("from");
        this.registerKeyword("full");
        this.registerKeyword("group");
        this.registerKeyword("having");
        this.registerKeyword("if");
        this.registerKeyword("in");
        this.registerKeyword("inner");
        this.registerKeyword("inout");
        this.registerKeyword("intersect");
        this.registerKeyword("into");
        this.registerKeyword("is");
        this.registerKeyword("join");
        this.registerKeyword("leading");
        this.registerKeyword("left");
        this.registerKeyword("limit");
        this.registerKeyword("loop");
        this.registerKeyword("minus");
        this.registerKeyword("natural");
        this.registerKeyword("nextval");
        this.registerKeyword("null");
        this.registerKeyword("on");
        this.registerKeyword("order");
        this.registerKeyword("out");
        this.registerKeyword("prior");
        this.registerKeyword("return");
        this.registerKeyword("returns");
        this.registerKeyword("reverse");
        this.registerKeyword("right");
        this.registerKeyword("rollup");
        this.registerKeyword("rowid");
        this.registerKeyword("select");
        this.registerKeyword("set");
        this.registerKeyword("sql");
        this.registerKeyword("start");
        this.registerKeyword("sysdate");
        this.registerKeyword("systime");
        this.registerKeyword("systimestamp");
        this.registerKeyword("sysuuid");
        this.registerKeyword("top");
        this.registerKeyword("trailing");
        this.registerKeyword("union");
        this.registerKeyword("using");
        this.registerKeyword("utcdate");
        this.registerKeyword("utctime");
        this.registerKeyword("utctimestamp");
        this.registerKeyword("values");
        this.registerKeyword("when");
        this.registerKeyword("where");
        this.registerKeyword("while");
        this.registerKeyword("with");
    }

    @Override
    public boolean supportsCircularCascadeDeleteConstraints() {
        return false;
    }

    @Override
    public ScrollMode defaultScrollMode() {
        return ScrollMode.FORWARD_ONLY;
    }

    @Override
    public boolean supportsColumnCheck() {
        return false;
    }

    @Override
    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    @Override
    public boolean supportsEmptyInList() {
        return false;
    }

    @Override
    public boolean supportsExistsInSelect() {
        return false;
    }

    @Override
    public boolean supportsExpectedLobUsagePattern() {
        return false;
    }

    @Override
    public boolean supportsLimit() {
        return true;
    }

    @Override
    public boolean supportsPooledSequences() {
        return true;
    }

    @Override
    public boolean supportsSequences() {
        return true;
    }

    @Override
    public boolean supportsTableCheck() {
        return false;
    }

    @Override
    public boolean supportsTupleDistinctCounts() {
        return false;
    }

    @Override
    public boolean supportsUnionAll() {
        return true;
    }

    @Override
    public boolean dropConstraints() {
        return false;
    }

    @Override
    public boolean supportsRowValueConstructorSyntax() {
        return true;
    }

    @Override
    public boolean supportsRowValueConstructorSyntaxInInList() {
        return true;
    }

    @Override
    public int getMaxAliasLength() {
        return 128;
    }

    @Override
    public String getAddForeignKeyConstraintString(String constraintName, String[] foreignKey, String referencedTable, String[] primaryKey, boolean referencesPrimaryKey) {
        return super.getAddForeignKeyConstraintString(constraintName, foreignKey, referencedTable, primaryKey, referencesPrimaryKey) + " on update cascade";
    }

    @Override
    public LimitHandler getLimitHandler() {
        return LIMIT_HANDLER;
    }

    private static class CloseSuppressingReader
    extends FilterReader {
        protected CloseSuppressingReader(Reader in) {
            super(in);
        }

        @Override
        public void close() {
        }
    }
}

