/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.impl;

import java.io.IOException;
import org.apache.lucene.store.LockObtainFailedException;
import org.infinispan.lucene.impl.ObtainableLock;

public class CommonLockObtainUtils {
    private static final int MAX_LOCK_ACQUIRE_MILLISECONDS = 10;

    private CommonLockObtainUtils() {
    }

    public static void attemptObtain(ObtainableLock lock) throws IOException {
        int attempts = 0;
        while (!lock.obtain()) {
            if (attempts++ > 10) {
                CommonLockObtainUtils.failLockAcquire();
            }
            if (Thread.currentThread().isInterrupted()) {
                CommonLockObtainUtils.failLockAcquire();
            }
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                CommonLockObtainUtils.failLockAcquire();
            }
        }
    }

    private static void failLockAcquire() throws LockObtainFailedException {
        throw new LockObtainFailedException("lock instance already assigned");
    }
}

