/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.core.impl.wireformat;

import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.core.protocol.core.impl.PacketImpl;

public class SessionAcknowledgeMessage
extends PacketImpl {
    private long consumerID;
    private long messageID;
    private boolean requiresResponse;

    public SessionAcknowledgeMessage(long consumerID, long messageID, boolean requiresResponse) {
        super((byte)41);
        this.consumerID = consumerID;
        this.messageID = messageID;
        this.requiresResponse = requiresResponse;
    }

    public SessionAcknowledgeMessage() {
        super((byte)41);
    }

    public long getConsumerID() {
        return this.consumerID;
    }

    public long getMessageID() {
        return this.messageID;
    }

    public boolean isRequiresResponse() {
        return this.requiresResponse;
    }

    @Override
    public void encodeRest(HornetQBuffer buffer) {
        buffer.writeLong(this.consumerID);
        buffer.writeLong(this.messageID);
        buffer.writeBoolean(this.requiresResponse);
    }

    @Override
    public void decodeRest(HornetQBuffer buffer) {
        this.consumerID = buffer.readLong();
        this.messageID = buffer.readLong();
        this.requiresResponse = buffer.readBoolean();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (int)(this.consumerID ^ this.consumerID >>> 32);
        result = 31 * result + (int)(this.messageID ^ this.messageID >>> 32);
        result = 31 * result + (this.requiresResponse ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SessionAcknowledgeMessage)) {
            return false;
        }
        SessionAcknowledgeMessage other = (SessionAcknowledgeMessage)obj;
        if (this.consumerID != other.consumerID) {
            return false;
        }
        if (this.messageID != other.messageID) {
            return false;
        }
        return this.requiresResponse == other.requiresResponse;
    }
}

