/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.core.impl.wireformat;

import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.core.protocol.core.impl.PacketImpl;

public class SessionAddMetaDataMessageV2
extends PacketImpl {
    private String key;
    private String data;
    private boolean requiresConfirmation = true;

    public SessionAddMetaDataMessageV2() {
        super((byte)105);
    }

    protected SessionAddMetaDataMessageV2(byte packetCode) {
        super(packetCode);
    }

    public SessionAddMetaDataMessageV2(String k, String d) {
        this();
        this.key = k;
        this.data = d;
    }

    protected SessionAddMetaDataMessageV2(byte packetCode, String k, String d) {
        super(packetCode);
        this.key = k;
        this.data = d;
    }

    public SessionAddMetaDataMessageV2(String k, String d, boolean requiresConfirmation) {
        this();
        this.key = k;
        this.data = d;
        this.requiresConfirmation = requiresConfirmation;
    }

    @Override
    public void encodeRest(HornetQBuffer buffer) {
        buffer.writeString(this.key);
        buffer.writeString(this.data);
        buffer.writeBoolean(this.requiresConfirmation);
    }

    @Override
    public void decodeRest(HornetQBuffer buffer) {
        this.key = buffer.readString();
        this.data = buffer.readString();
        this.requiresConfirmation = buffer.readBoolean();
    }

    @Override
    public final boolean isRequiresConfirmations() {
        return this.requiresConfirmation;
    }

    public String getKey() {
        return this.key;
    }

    public String getData() {
        return this.data;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.data == null ? 0 : this.data.hashCode());
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        result = 31 * result + (this.requiresConfirmation ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SessionAddMetaDataMessageV2)) {
            return false;
        }
        SessionAddMetaDataMessageV2 other = (SessionAddMetaDataMessageV2)obj;
        if (this.data == null ? other.data != null : !this.data.equals(other.data)) {
            return false;
        }
        if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
            return false;
        }
        return this.requiresConfirmation == other.requiresConfirmation;
    }
}

