/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.journal.impl.dataformat;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.journal.EncodingSupport;
import org.apache.activemq.artemis.core.journal.impl.dataformat.JournalInternalRecord;

public class JournalAddRecord
extends JournalInternalRecord {
    private final long id;
    private final EncodingSupport record;
    private final byte recordType;
    private final boolean add;

    public JournalAddRecord(boolean add, long id, byte recordType, EncodingSupport record) {
        this.id = id;
        this.record = record;
        this.recordType = recordType;
        this.add = add;
    }

    @Override
    public void encode(ActiveMQBuffer buffer) {
        if (this.add) {
            buffer.writeByte((byte)11);
        } else {
            buffer.writeByte((byte)12);
        }
        buffer.writeInt(this.fileID);
        buffer.writeByte(this.compactCount);
        buffer.writeLong(this.id);
        buffer.writeInt(this.record.getEncodeSize());
        buffer.writeByte(this.recordType);
        this.record.encode(buffer);
        buffer.writeInt(this.getEncodeSize());
    }

    @Override
    public int getEncodeSize() {
        return 22 + this.record.getEncodeSize() + 1;
    }
}

