/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors.merging;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.ejb.Remove;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.metadata.MethodAnnotationAggregator;
import org.jboss.as.ee.metadata.RuntimeAnnotationInformation;
import org.jboss.as.ejb3.component.stateful.StatefulComponentDescription;
import org.jboss.as.ejb3.deployment.processors.dd.MethodResolutionUtils;
import org.jboss.as.ejb3.deployment.processors.merging.AbstractMergingProcessor;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.invocation.proxy.MethodIdentifier;
import org.jboss.metadata.ejb.spec.NamedMethodMetaData;
import org.jboss.metadata.ejb.spec.RemoveMethodMetaData;
import org.jboss.metadata.ejb.spec.SessionBeanMetaData;

public class RemoveMethodMergingProcessor
extends AbstractMergingProcessor<StatefulComponentDescription> {
    public RemoveMethodMergingProcessor() {
        super(StatefulComponentDescription.class);
    }

    @Override
    protected void handleAnnotations(DeploymentUnit deploymentUnit, EEApplicationClasses applicationClasses, DeploymentReflectionIndex deploymentReflectionIndex, Class<?> componentClass, StatefulComponentDescription componentConfiguration) throws DeploymentUnitProcessingException {
        RuntimeAnnotationInformation removeMethods = MethodAnnotationAggregator.runtimeAnnotationInformation(componentClass, (EEApplicationClasses)applicationClasses, (DeploymentReflectionIndex)deploymentReflectionIndex, Remove.class);
        for (Map.Entry entry : removeMethods.getMethodAnnotations().entrySet()) {
            if (((List)entry.getValue()).isEmpty()) continue;
            Boolean retainIfException = (Boolean)((List)entry.getValue()).get(0);
            MethodIdentifier removeMethodIdentifier = MethodIdentifier.getIdentifierForMethod((Method)((Method)entry.getKey()));
            componentConfiguration.addRemoveMethod(removeMethodIdentifier, retainIfException);
        }
    }

    @Override
    protected void handleDeploymentDescriptor(DeploymentUnit deploymentUnit, DeploymentReflectionIndex deploymentReflectionIndex, Class<?> componentClass, StatefulComponentDescription componentConfiguration) throws DeploymentUnitProcessingException {
        MethodIdentifier methodIdentifier;
        Boolean retainIfException;
        Collection<Method> methods;
        NamedMethodMetaData methodData;
        SessionBeanMetaData beanMetaData = componentConfiguration.getDescriptorData();
        if (beanMetaData == null) {
            return;
        }
        if (beanMetaData.getRemoveMethods() == null || beanMetaData.getRemoveMethods().isEmpty()) {
            return;
        }
        DeploymentReflectionIndex reflectionIndex = (DeploymentReflectionIndex)deploymentUnit.getAttachment(Attachments.REFLECTION_INDEX);
        HashSet<MethodIdentifier> annotationRemoveMethods = new HashSet<MethodIdentifier>();
        for (StatefulComponentDescription.StatefulRemoveMethod method : componentConfiguration.getRemoveMethods()) {
            annotationRemoveMethods.add(method.getMethodIdentifier());
        }
        for (RemoveMethodMetaData removeMethod : beanMetaData.getRemoveMethods()) {
            if (removeMethod.getBeanMethod().getMethodParams() != null) continue;
            methodData = removeMethod.getBeanMethod();
            methods = MethodResolutionUtils.resolveMethods(methodData, componentClass, reflectionIndex);
            for (Method method : methods) {
                retainIfException = removeMethod.getRetainIfException();
                methodIdentifier = MethodIdentifier.getIdentifierForMethod((Method)method);
                if (retainIfException == null) {
                    if (annotationRemoveMethods.contains(methodIdentifier)) continue;
                    componentConfiguration.addRemoveMethod(methodIdentifier, false);
                    continue;
                }
                componentConfiguration.addRemoveMethod(methodIdentifier, retainIfException);
            }
        }
        for (RemoveMethodMetaData removeMethod : beanMetaData.getRemoveMethods()) {
            if (removeMethod.getBeanMethod().getMethodParams() == null) continue;
            methodData = removeMethod.getBeanMethod();
            methods = MethodResolutionUtils.resolveMethods(methodData, componentClass, reflectionIndex);
            for (Method method : methods) {
                retainIfException = removeMethod.getRetainIfException();
                methodIdentifier = MethodIdentifier.getIdentifierForMethod((Method)method);
                if (retainIfException == null) {
                    if (annotationRemoveMethods.contains(methodIdentifier)) continue;
                    componentConfiguration.addRemoveMethod(methodIdentifier, false);
                    continue;
                }
                componentConfiguration.addRemoveMethod(methodIdentifier, retainIfException);
            }
        }
    }
}

