/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.websocket.json;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.codehaus.jackson.map.ObjectMapper;
import org.infinispan.server.websocket.json.JsonConversionException;
import org.infinispan.server.websocket.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class JsonObject
implements Map<String, Object> {
    private static final Log logger = (Log)LogFactory.getLog(MethodHandles.lookup().lookupClass(), Log.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private final Map<String, Object> internalStructure;

    private JsonObject(Map<String, Object> internalStructure) {
        this.internalStructure = internalStructure;
    }

    public static JsonObject fromString(String json) throws JsonConversionException {
        try {
            Map readValue = (Map)objectMapper.readValue(json, Map.class);
            return new JsonObject(readValue);
        }
        catch (Exception e) {
            throw logger.unableToConvertFromStringToJson(json, e);
        }
    }

    public static JsonObject fromObject(Object o) throws JsonConversionException {
        try {
            Map convertValue = (Map)objectMapper.convertValue(o, Map.class);
            return new JsonObject(convertValue);
        }
        catch (Exception e) {
            throw logger.unableToConvertFromObjectToJson(o, e);
        }
    }

    public static JsonObject fromMap(Map<String, Object> map) {
        return new JsonObject(map);
    }

    public static JsonObject createNew() {
        return new JsonObject(new HashMap<String, Object>());
    }

    public String toString() {
        try {
            return objectMapper.writeValueAsString(this.internalStructure);
        }
        catch (IOException e) {
            throw logger.unableToConvertFromJsonToString(e);
        }
    }

    @Override
    public int size() {
        return this.internalStructure.size();
    }

    @Override
    public boolean isEmpty() {
        return this.internalStructure.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.internalStructure.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.internalStructure.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        return this.internalStructure.get(key);
    }

    @Override
    public Object put(String key, Object value) {
        return this.internalStructure.put(key, value);
    }

    @Override
    public Object remove(Object key) {
        return this.internalStructure.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
        this.internalStructure.putAll(m);
    }

    @Override
    public void clear() {
        this.internalStructure.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.internalStructure.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.internalStructure.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.internalStructure.entrySet();
    }
}

