/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.cli.impl.CliConfigImpl;
import org.jboss.as.cli.impl.Namespace;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLMapper;

class VaultConfig {
    private static final String NAME = "name";
    private static final String VALUE = "value";
    private static final String VAULT = "vault";
    private static final String CODE = "code";
    private static final String MODULE = "module";
    private static final String VAULT_OPTION = "vault-option";
    private String code;
    private String module;
    private final Map<String, Object> options = new HashMap<String, Object>();

    VaultConfig() {
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static VaultConfig loadExternalFile(File f) throws XMLStreamException {
        if (f == null) {
            throw new IllegalArgumentException("File is null");
        }
        if (!f.exists()) {
            throw new XMLStreamException("Failed to locate vault file " + f.getAbsolutePath());
        }
        VaultConfig config = new VaultConfig();
        BufferedInputStream input = null;
        try {
            XMLMapper mapper = XMLMapper.Factory.create();
            ExternalVaultConfigReader reader = new ExternalVaultConfigReader();
            mapper.registerRootElement(new QName(VAULT), reader);
            FileInputStream is = new FileInputStream(f);
            input = new BufferedInputStream(is);
            XMLStreamReader streamReader = XMLInputFactory.newInstance().createXMLStreamReader(input);
            mapper.parseDocument(config, streamReader);
            streamReader.close();
        }
        catch (FileNotFoundException e) {
            try {
                throw new XMLStreamException("Vault file not found", e);
                catch (XMLStreamException t) {
                    throw t;
                }
            }
            catch (Throwable throwable) {
                StreamUtils.safeClose(input);
                throw throwable;
            }
        }
        StreamUtils.safeClose(input);
        return config;
    }

    static VaultConfig readVaultElement_3_0(XMLExtendedStreamReader reader, Namespace expectedNs) throws XMLStreamException {
        VaultConfig config = new VaultConfig();
        int count = reader.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            String name = reader.getAttributeLocalName(i);
            if (name.equals(CODE)) {
                config.code = value;
                continue;
            }
            if (name.equals(MODULE)) {
                config.module = value;
                continue;
            }
            VaultConfig.unexpectedVaultAttribute(reader.getAttributeLocalName(i), reader);
        }
        if (config.code == null && config.module != null) {
            throw new XMLStreamException("Attribute 'module' was specified without an attribute 'code' for element 'vault' at " + reader.getLocation());
        }
        VaultConfig.readVaultOptions(reader, config);
        return config;
    }

    Map<String, Object> getOptions() {
        return this.options;
    }

    String getCode() {
        return this.code;
    }

    String getModule() {
        return this.module;
    }

    private void addOption(String name, String value) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("name is null or empty");
        }
        if (value == null || value.isEmpty()) {
            throw new IllegalArgumentException("value is null or empty");
        }
        this.options.put(name, value);
    }

    private static void readVaultOptions(XMLExtendedStreamReader reader, VaultConfig config) throws XMLStreamException {
        boolean done = false;
        while (reader.hasNext() && !done) {
            String localName;
            int tag = reader.nextTag();
            if (tag == 1) {
                localName = reader.getLocalName();
                if (localName.equals(VAULT_OPTION)) {
                    String name = reader.getAttributeValue(null, NAME);
                    if (name == null) {
                        throw new XMLStreamException("Attribute 'name' is not found for element 'vault-option' at " + reader.getLocation());
                    }
                    String value = reader.getAttributeValue(null, VALUE);
                    if (value == null) {
                        throw new XMLStreamException("Attribute 'value' is not found for element vault-option' at " + reader.getLocation());
                    }
                    config.addOption(name.trim(), value.trim());
                    CliConfigImpl.CliConfigReader.requireNoContent(reader);
                    continue;
                }
                throw new XMLStreamException("Unexpected element: " + localName);
            }
            if (tag != 2 || !(localName = reader.getLocalName()).equals(VAULT)) continue;
            done = true;
        }
    }

    private static void unexpectedVaultAttribute(String attribute, XMLStreamReader reader) throws XMLStreamException {
        throw new XMLStreamException("Attribute '" + attribute + "' is unknown for element '" + VAULT_OPTION + "' at " + reader.getLocation());
    }

    private static class ExternalVaultConfigReader
    implements XMLElementReader<VaultConfig> {
        private ExternalVaultConfigReader() {
        }

        @Override
        public void readElement(XMLExtendedStreamReader reader, VaultConfig config) throws XMLStreamException {
            String rootName = reader.getLocalName();
            if (!VaultConfig.VAULT.equals(rootName)) {
                throw new XMLStreamException("Unexpected element: " + rootName);
            }
            int count = reader.getAttributeCount();
            for (int i = 0; i < count; ++i) {
                String value = reader.getAttributeValue(i);
                VaultConfig.unexpectedVaultAttribute(reader.getAttributeLocalName(i), reader);
            }
            if (config.code == null && config.module != null) {
                throw new XMLStreamException("Attribute 'module' was specified without an attribute 'code' for element 'vault' at " + reader.getLocation());
            }
            VaultConfig.readVaultOptions(reader, config);
        }
    }
}

