/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.ssl;

import java.util.EnumSet;
import org.wildfly.security.ssl.CipherSuitePredicate;
import org.wildfly.security.ssl.Digest;
import org.wildfly.security.ssl.MechanismDatabase;

final class DigestCipherSuitePredicate
extends CipherSuitePredicate {
    private final EnumSet<Digest> set;

    DigestCipherSuitePredicate(EnumSet<Digest> set) {
        this.set = set;
    }

    @Override
    public boolean test(MechanismDatabase.Entry entry) {
        return this.set.contains((Object)entry.getDigest());
    }

    @Override
    boolean isAlwaysTrue() {
        return this.set.size() == Digest.fullSize;
    }

    @Override
    boolean isAlwaysFalse() {
        return this.set.isEmpty();
    }
}

