/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.interpreter.statement;

import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.infinispan.cli.interpreter.logging.Log;
import org.infinispan.cli.interpreter.result.EmptyResult;
import org.infinispan.cli.interpreter.result.Result;
import org.infinispan.cli.interpreter.result.StatementException;
import org.infinispan.cli.interpreter.session.Session;
import org.infinispan.cli.interpreter.statement.AbstractTransactionStatement;
import org.infinispan.util.logging.LogFactory;

public class BeginTransactionStatement
extends AbstractTransactionStatement {
    private static final Log log = (Log)LogFactory.getLog(BeginTransactionStatement.class, Log.class);

    public BeginTransactionStatement(String cacheName) {
        super(cacheName);
    }

    @Override
    public Result execute(Session session) throws StatementException {
        TransactionManager tm = this.getTransactionManager(session);
        if (tm == null) {
            throw log.noTransactionManager();
        }
        try {
            tm.begin();
            return EmptyResult.RESULT;
        }
        catch (NotSupportedException e) {
            throw log.noNestedTransactions();
        }
        catch (SystemException e) {
            throw log.unexpectedTransactionError(e);
        }
    }
}

