/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.impl;

import java.util.Set;
import org.apache.lucene.search.similarities.Similarity;
import org.hibernate.search.engine.spi.DocumentBuilderIndexedEntity;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.indexes.impl.IndexManagerGroupHolder;
import org.hibernate.search.indexes.interceptor.EntityIndexingInterceptor;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.indexes.spi.IndexManagerSelector;
import org.hibernate.search.indexes.spi.IndexManagerType;
import org.hibernate.search.spi.IndexedTypeSet;
import org.hibernate.search.store.ShardIdentifierProvider;

public class MutableEntityIndexBinding
implements EntityIndexBinding {
    private final IndexManagerGroupHolder indexManagerGroupHolder;
    private final IndexManagerSelector indexManagerSelector;
    private final ShardIdentifierProvider shardIdentifierProvider;
    private DocumentBuilderIndexedEntity documentBuilder;
    private final EntityIndexingInterceptor<?> entityIndexingInterceptor;

    public MutableEntityIndexBinding(IndexManagerGroupHolder indexManagerGroupHolder, IndexManagerSelector indexManagerSelector, ShardIdentifierProvider shardIdentifierProvider, EntityIndexingInterceptor<?> entityIndexingInterceptor) {
        this.indexManagerGroupHolder = indexManagerGroupHolder;
        this.indexManagerSelector = indexManagerSelector;
        this.shardIdentifierProvider = shardIdentifierProvider;
        this.entityIndexingInterceptor = entityIndexingInterceptor;
    }

    public void setDocumentBuilderIndexedEntity(DocumentBuilderIndexedEntity documentBuilder) {
        this.documentBuilder = documentBuilder;
    }

    @Override
    public Similarity getSimilarity() {
        return this.indexManagerGroupHolder.getSimilarity();
    }

    @Override
    public IndexManagerSelector getIndexManagerSelector() {
        return this.indexManagerSelector;
    }

    @Override
    public ShardIdentifierProvider getShardIdentifierProvider() {
        return this.shardIdentifierProvider;
    }

    @Override
    public DocumentBuilderIndexedEntity getDocumentBuilder() {
        return this.documentBuilder;
    }

    @Override
    public void postInitialize(IndexedTypeSet indexedClasses) {
        this.documentBuilder.postInitialize(indexedClasses);
    }

    @Override
    public IndexManagerType getIndexManagerType() {
        return this.indexManagerGroupHolder.getIndexManagerType();
    }

    @Override
    public IndexManager[] getIndexManagers() {
        Set<IndexManager> set = this.indexManagerSelector.all();
        return set.toArray(new IndexManager[set.size()]);
    }

    @Override
    public EntityIndexingInterceptor<?> getEntityIndexingInterceptor() {
        return this.entityIndexingInterceptor;
    }
}

