/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.indexes.impl;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.hibernate.search.filter.FullTextFilterImplementor;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.indexes.spi.IndexManagerSelector;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.store.IndexShardingStrategy;

public class IndexShardingStrategyIndexManagerSelector
implements IndexManagerSelector {
    private final IndexShardingStrategy shardingStrategy;
    private final Set<IndexManager> allIndexManagers;

    public IndexShardingStrategyIndexManagerSelector(IndexShardingStrategy shardingStrategy, IndexManager[] allIndexManagers) {
        this.shardingStrategy = shardingStrategy;
        this.allIndexManagers = IndexShardingStrategyIndexManagerSelector.convertAll(shardingStrategy, allIndexManagers);
    }

    @Override
    public Set<IndexManager> all() {
        return this.allIndexManagers;
    }

    @Override
    public IndexManager forNew(IndexedTypeIdentifier typeId, Serializable id, String idInString, Document document) {
        return this.shardingStrategy.getIndexManagerForAddition(typeId.getPojoType(), id, idInString, document);
    }

    @Override
    public Set<IndexManager> forExisting(IndexedTypeIdentifier typeId, Serializable id, String idInString) {
        return IndexShardingStrategyIndexManagerSelector.toSet(this.shardingStrategy.getIndexManagersForDeletion(typeId.getPojoType(), id, idInString));
    }

    @Override
    public Set<IndexManager> forFilters(FullTextFilterImplementor[] fullTextFilters) {
        return IndexShardingStrategyIndexManagerSelector.toSet(this.shardingStrategy.getIndexManagersForQuery(fullTextFilters));
    }

    private static Set<IndexManager> toSet(IndexManager[] indexManagers) {
        if (indexManagers == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<IndexManager> set = new LinkedHashSet<IndexManager>(indexManagers.length);
        Collections.addAll(set, indexManagers);
        return set;
    }

    private static Set<IndexManager> convertAll(IndexShardingStrategy shardingStrategy, IndexManager[] allIndexManagers) {
        IndexManager[] indexManagers = shardingStrategy.getIndexManagersForAllShards();
        if (indexManagers == null) {
            indexManagers = allIndexManagers;
        }
        return IndexShardingStrategyIndexManagerSelector.toSet(indexManagers);
    }
}

