/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.spi.impl;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.spi.IndexedTypeMap;
import org.hibernate.search.spi.IndexedTypeSet;
import org.hibernate.search.spi.impl.IndexedTypeSets;
import org.hibernate.search.spi.impl.PojoIndexedTypeIdentifier;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class ConcurrentIndexedTypeMap<V>
implements IndexedTypeMap<V> {
    private static final Log log = LoggerFactory.make();
    private static final IndexedTypeIdentifier ROOT_OBJECT = new PojoIndexedTypeIdentifier(Object.class);
    private final ConcurrentHashMap<IndexedTypeIdentifier, V> map = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, IndexedTypeIdentifier> name2keyMapping = new ConcurrentHashMap();

    @Override
    public V get(IndexedTypeIdentifier key) {
        return this.map.get(key);
    }

    @Override
    public Iterable<Map.Entry<IndexedTypeIdentifier, V>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public V get(Class<?> legacyPojo) {
        return this.map.get(new PojoIndexedTypeIdentifier(legacyPojo));
    }

    @Override
    public IndexedTypeSet keySet() {
        return IndexedTypeSets.fromIdentifiers(this.map.keySet());
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }

    @Override
    public boolean containsKey(IndexedTypeIdentifier type) {
        return this.map.containsKey(type);
    }

    @Override
    public boolean containsKey(Class<?> legacyPojo) {
        return this.map.containsKey(new PojoIndexedTypeIdentifier(legacyPojo));
    }

    @Override
    public void put(IndexedTypeIdentifier type, V value) {
        this.name2keyMapping.put(type.getName(), type);
        this.map.put(type, value);
    }

    @Override
    public void put(Class<?> type, V typeBinding) {
        this.put(new PojoIndexedTypeIdentifier(type), typeBinding);
    }

    @Override
    public IndexedTypeIdentifier keyFromName(String entityClassName) {
        if (entityClassName == null) {
            throw log.nullIsInvalidIndexedType();
        }
        IndexedTypeIdentifier id = this.name2keyMapping.get(entityClassName);
        if (id == null) {
            throw log.notAnIndexedType(entityClassName);
        }
        return id;
    }

    @Override
    public IndexedTypeIdentifier keyFromPojoType(Class<?> clazz) {
        if (clazz == null) {
            throw log.nullIsInvalidIndexedType();
        }
        if (clazz == Object.class) {
            return ROOT_OBJECT;
        }
        return new PojoIndexedTypeIdentifier(clazz);
    }
}

