/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.scattered;

import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.infinispan.container.versioning.EntryVersion;

public interface ScatteredVersionManager<K> {
    public EntryVersion incrementVersion(int var1);

    public boolean isVersionActual(int var1, EntryVersion var2);

    public void scheduleKeyInvalidation(K var1, EntryVersion var2, boolean var3);

    public void clearInvalidations();

    public void registerSegment(int var1);

    public void unregisterSegment(int var1);

    public void setOwnedSegments(Set<Integer> var1);

    public void startKeyTransfer(Set<Integer> var1);

    public void notifyKeyTransferFinished(int var1, boolean var2);

    public void notifyValueTransferFinished();

    public SegmentState getSegmentState(int var1);

    public CompletableFuture<Void> getBlockingFuture(int var1);

    public void setValuesTransferTopology(int var1);

    public CompletableFuture<Void> valuesFuture(int var1);

    public void setTopologyId(int var1);

    public void updatePreloadedEntryVersion(EntryVersion var1);

    public static enum SegmentState {
        NOT_OWNED('N'),
        BLOCKED('B'),
        KEY_TRANSFER('K'),
        VALUE_TRANSFER('V'),
        OWNED('O');

        private final char singleChar;

        private SegmentState(char singleChar) {
            this.singleChar = singleChar;
        }

        public char singleChar() {
            return this.singleChar;
        }
    }
}

