/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.configuration;

import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;

public class TableManipulationConfiguration {
    public static final AttributeDefinition<String> ID_COLUMN_NAME = AttributeDefinition.builder((String)"idColumnName", null, String.class).immutable().build();
    public static final AttributeDefinition<String> ID_COLUMN_TYPE = AttributeDefinition.builder((String)"idColumnType", null, String.class).immutable().build();
    public static final AttributeDefinition<String> TABLE_NAME_PREFIX = AttributeDefinition.builder((String)"tableNamePrefix", null, String.class).immutable().build();
    public static final AttributeDefinition<String> CACHE_NAME = AttributeDefinition.builder((String)"cacheName", null, String.class).immutable().build();
    public static final AttributeDefinition<String> DATA_COLUMN_NAME = AttributeDefinition.builder((String)"dataColumnName", null, String.class).immutable().build();
    public static final AttributeDefinition<String> DATA_COLUMN_TYPE = AttributeDefinition.builder((String)"dataColumnType", null, String.class).immutable().build();
    public static final AttributeDefinition<String> TIMESTAMP_COLUMN_NAME = AttributeDefinition.builder((String)"timestampColumnName", null, String.class).immutable().build();
    public static final AttributeDefinition<String> TIMESTAMP_COLUMN_TYPE = AttributeDefinition.builder((String)"timestampColumnType", null, String.class).immutable().build();
    public static final AttributeDefinition<Integer> FETCH_SIZE = AttributeDefinition.builder((String)"fetchSize", (Object)100).immutable().build();
    public static final AttributeDefinition<Boolean> CREATE_ON_START = AttributeDefinition.builder((String)"createOnStart", (Object)true).immutable().build();
    public static final AttributeDefinition<Boolean> DROP_ON_EXIT = AttributeDefinition.builder((String)"dropOnExit", (Object)false).immutable().build();
    private final Attribute<String> idColumnName;
    private final Attribute<String> idColumnType;
    private final Attribute<String> tableNamePrefix;
    private final Attribute<String> cacheName;
    private final Attribute<String> dataColumnName;
    private final Attribute<String> dataColumnType;
    private final Attribute<String> timestampColumnName;
    private final Attribute<String> timestampColumnType;
    private final Attribute<Integer> fetchSize;
    private final Attribute<Boolean> createOnStart;
    private final Attribute<Boolean> dropOnExit;
    private final AttributeSet attributes;
    private final int batchSize;

    static AttributeSet attributeSet() {
        return new AttributeSet(TableManipulationConfiguration.class, new AttributeDefinition[]{ID_COLUMN_NAME, ID_COLUMN_TYPE, TABLE_NAME_PREFIX, CACHE_NAME, DATA_COLUMN_NAME, DATA_COLUMN_TYPE, TIMESTAMP_COLUMN_NAME, TIMESTAMP_COLUMN_TYPE, FETCH_SIZE, CREATE_ON_START, DROP_ON_EXIT});
    }

    TableManipulationConfiguration(AttributeSet attributes, int batchSize) {
        this.batchSize = batchSize;
        this.attributes = attributes.checkProtection();
        this.idColumnName = attributes.attribute(ID_COLUMN_NAME);
        this.idColumnType = attributes.attribute(ID_COLUMN_TYPE);
        this.tableNamePrefix = attributes.attribute(TABLE_NAME_PREFIX);
        this.cacheName = attributes.attribute(CACHE_NAME);
        this.dataColumnName = attributes.attribute(DATA_COLUMN_NAME);
        this.dataColumnType = attributes.attribute(DATA_COLUMN_TYPE);
        this.timestampColumnName = attributes.attribute(TIMESTAMP_COLUMN_NAME);
        this.timestampColumnType = attributes.attribute(TIMESTAMP_COLUMN_TYPE);
        this.fetchSize = attributes.attribute(FETCH_SIZE);
        this.createOnStart = attributes.attribute(CREATE_ON_START);
        this.dropOnExit = attributes.attribute(DROP_ON_EXIT);
    }

    public boolean createOnStart() {
        return (Boolean)this.createOnStart.get();
    }

    public boolean dropOnExit() {
        return (Boolean)this.dropOnExit.get();
    }

    public String idColumnName() {
        return (String)this.idColumnName.get();
    }

    public String idColumnType() {
        return (String)this.idColumnType.get();
    }

    public String tableNamePrefix() {
        return (String)this.tableNamePrefix.get();
    }

    public String cacheName() {
        return (String)this.cacheName.get();
    }

    public String dataColumnName() {
        return (String)this.dataColumnName.get();
    }

    public String dataColumnType() {
        return (String)this.dataColumnType.get();
    }

    public String timestampColumnName() {
        return (String)this.timestampColumnName.get();
    }

    public String timestampColumnType() {
        return (String)this.timestampColumnType.get();
    }

    public int fetchSize() {
        return (Integer)this.fetchSize.get();
    }

    @Deprecated
    public int batchSize() {
        return this.batchSize;
    }

    AttributeSet attributes() {
        return this.attributes;
    }

    public String toString() {
        return "TableManipulationConfiguration [attributes=" + this.attributes + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TableManipulationConfiguration other = (TableManipulationConfiguration)obj;
        return !(this.attributes == null ? other.attributes != null : !this.attributes.equals((Object)other.attributes));
    }
}

