/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.endpoint.subsystem.security;

import java.io.IOException;
import java.security.Principal;
import java.util.Collections;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import org.infinispan.rest.authentication.SecurityDomain;
import org.infinispan.security.Security;
import org.infinispan.server.core.security.simple.SimpleUserPrincipal;
import org.infinispan.server.endpoint.EndpointLogger;
import org.jboss.as.core.security.SubjectUserInfo;
import org.jboss.as.domain.management.AuthMechanism;
import org.jboss.as.domain.management.AuthorizingCallbackHandler;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.sasl.callback.VerifyPasswordCallback;

public class BasicRestSecurityDomain
implements SecurityDomain {
    private final SecurityRealm securityRealm;

    public BasicRestSecurityDomain(SecurityRealm securityRealm) {
        this.securityRealm = securityRealm;
    }

    public Principal authenticate(String username, String password) throws SecurityException {
        AuthorizingCallbackHandler handler = this.securityRealm.getAuthorizingCallbackHandler(AuthMechanism.PLAIN);
        NameCallback ncb = new NameCallback("name", username);
        ncb.setName(username);
        VerifyPasswordCallback vpcb = new VerifyPasswordCallback(password);
        try {
            handler.handle(new Callback[]{ncb, vpcb});
        }
        catch (Exception e) {
            EndpointLogger.ROOT_LOGGER.authenticationError(e);
        }
        if (vpcb.isVerified()) {
            try {
                SubjectUserInfo subjectUserInfo = handler.createSubjectUserInfo(Collections.singletonList(new SimpleUserPrincipal(username)));
                return Security.getSubjectUserPrincipal((Subject)subjectUserInfo.getSubject());
            }
            catch (IOException e) {
                throw new SecurityException("Invalid credentials", e);
            }
        }
        throw new SecurityException("Invalid credentials");
    }
}

