/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.analyzer.impl;

import java.util.Map;
import org.hibernate.search.elasticsearch.analyzer.definition.impl.ElasticsearchAnalysisDefinitionRegistry;
import org.hibernate.search.elasticsearch.analyzer.definition.impl.ElasticsearchAnalysisDefinitionRegistryPopulator;
import org.hibernate.search.elasticsearch.analyzer.impl.NamedElasticsearchAnalyzerReference;
import org.hibernate.search.elasticsearch.analyzer.impl.SimpleElasticsearchAnalysisDefinitionRegistryPopulator;
import org.hibernate.search.elasticsearch.settings.impl.model.AnalyzerDefinition;
import org.hibernate.search.elasticsearch.settings.impl.model.CharFilterDefinition;
import org.hibernate.search.elasticsearch.settings.impl.model.NormalizerDefinition;
import org.hibernate.search.elasticsearch.settings.impl.model.TokenFilterDefinition;
import org.hibernate.search.elasticsearch.settings.impl.model.TokenizerDefinition;

public class NamedElasticsearch2NormalizerReference
extends NamedElasticsearchAnalyzerReference {
    public NamedElasticsearch2NormalizerReference(String name) {
        super(name);
    }

    @Override
    public boolean isNormalizer(String fieldName) {
        return true;
    }

    @Override
    protected ElasticsearchAnalysisDefinitionRegistryPopulator createRegistryPopulator(ElasticsearchAnalysisDefinitionRegistry definitionRegistry) {
        NormalizerDefinition normalizerDefinition = definitionRegistry.getNormalizerDefinition(this.name);
        if (normalizerDefinition == null) {
            return r -> {};
        }
        AnalyzerDefinition analyzerDefinition = this.normalizerToAnalyzer(normalizerDefinition);
        String tokenizerName = analyzerDefinition.getTokenizer();
        TokenizerDefinition tokenizerDefinition = definitionRegistry.getTokenizerDefinition(tokenizerName);
        Map<String, TokenFilterDefinition> tokenFilters = this.collectDefinitions(definitionRegistry::getTokenFilterDefinition, analyzerDefinition.getTokenFilters());
        Map<String, CharFilterDefinition> charFilters = this.collectDefinitions(definitionRegistry::getCharFilterDefinition, analyzerDefinition.getCharFilters());
        return new SimpleElasticsearchAnalysisDefinitionRegistryPopulator(this.name, analyzerDefinition, tokenizerName, tokenizerDefinition, charFilters, tokenFilters);
    }

    private AnalyzerDefinition normalizerToAnalyzer(NormalizerDefinition definition) {
        AnalyzerDefinition analyzerDefinition = new AnalyzerDefinition();
        analyzerDefinition.setTokenizer("keyword");
        analyzerDefinition.setCharFilters(definition.getCharFilters());
        analyzerDefinition.setTokenFilters(definition.getTokenFilters());
        return analyzerDefinition;
    }
}

