/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.bridge.impl;

import java.lang.reflect.AnnotatedElement;
import java.util.Calendar;
import java.util.Date;
import org.hibernate.search.annotations.CalendarBridge;
import org.hibernate.search.annotations.DateBridge;
import org.hibernate.search.annotations.Resolution;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.impl.ExtendedBridgeProvider;
import org.hibernate.search.elasticsearch.bridge.builtin.impl.ElasticsearchCalendarBridge;
import org.hibernate.search.elasticsearch.bridge.builtin.impl.ElasticsearchDateBridge;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

class ElasticsearchJavaUtilTimeBridgeProvider
extends ExtendedBridgeProvider {
    private static final Log LOG = (Log)LoggerFactory.make(Log.class);

    ElasticsearchJavaUtilTimeBridgeProvider() {
    }

    public FieldBridge provideFieldBridge(ExtendedBridgeProvider.ExtendedBridgeProviderContext context) {
        AnnotatedElement annotatedElement = context.getAnnotatedElement();
        if (Date.class.isAssignableFrom(context.getReturnType())) {
            Resolution resolution = this.getDateResolution(annotatedElement);
            return this.getDateFieldBridge(resolution);
        }
        if (Calendar.class.isAssignableFrom(context.getReturnType())) {
            Resolution resolution = this.getCalendarResolution(annotatedElement);
            return this.getCalendarFieldBridge(resolution);
        }
        return null;
    }

    private Resolution getDateResolution(AnnotatedElement annotatedElement) {
        if (annotatedElement.isAnnotationPresent(DateBridge.class)) {
            return annotatedElement.getAnnotation(DateBridge.class).resolution();
        }
        return Resolution.MILLISECOND;
    }

    private Resolution getCalendarResolution(AnnotatedElement annotatedElement) {
        if (annotatedElement.isAnnotationPresent(CalendarBridge.class)) {
            return annotatedElement.getAnnotation(CalendarBridge.class).resolution();
        }
        return Resolution.MILLISECOND;
    }

    private FieldBridge getDateFieldBridge(Resolution resolution) {
        switch (resolution) {
            case YEAR: {
                return ElasticsearchDateBridge.DATE_YEAR;
            }
            case MONTH: {
                return ElasticsearchDateBridge.DATE_MONTH;
            }
            case DAY: {
                return ElasticsearchDateBridge.DATE_DAY;
            }
            case HOUR: {
                return ElasticsearchDateBridge.DATE_HOUR;
            }
            case MINUTE: {
                return ElasticsearchDateBridge.DATE_MINUTE;
            }
            case SECOND: {
                return ElasticsearchDateBridge.DATE_SECOND;
            }
            case MILLISECOND: {
                return ElasticsearchDateBridge.DATE_MILLISECOND;
            }
        }
        throw LOG.unknownResolution(resolution.toString());
    }

    private FieldBridge getCalendarFieldBridge(Resolution resolution) {
        switch (resolution) {
            case YEAR: {
                return ElasticsearchCalendarBridge.DATE_YEAR;
            }
            case MONTH: {
                return ElasticsearchCalendarBridge.DATE_MONTH;
            }
            case DAY: {
                return ElasticsearchCalendarBridge.DATE_DAY;
            }
            case HOUR: {
                return ElasticsearchCalendarBridge.DATE_HOUR;
            }
            case MINUTE: {
                return ElasticsearchCalendarBridge.DATE_MINUTE;
            }
            case SECOND: {
                return ElasticsearchCalendarBridge.DATE_SECOND;
            }
            case MILLISECOND: {
                return ElasticsearchCalendarBridge.DATE_MILLISECOND;
            }
        }
        throw LOG.unknownResolution(resolution.toString());
    }
}

