/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.processor.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.impl.lucene.MultiWriteDrainableLinkedList;
import org.hibernate.search.elasticsearch.client.impl.ElasticsearchClient;
import org.hibernate.search.elasticsearch.gson.impl.GsonProvider;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.elasticsearch.processor.impl.ParallelWorkExecutionContext;
import org.hibernate.search.elasticsearch.processor.impl.SequentialWorkExecutionContext;
import org.hibernate.search.elasticsearch.work.impl.BulkRequestFailedException;
import org.hibernate.search.elasticsearch.work.impl.BulkableElasticsearchWork;
import org.hibernate.search.elasticsearch.work.impl.ElasticsearchWork;
import org.hibernate.search.elasticsearch.work.impl.ElasticsearchWorkAggregator;
import org.hibernate.search.elasticsearch.work.impl.ElasticsearchWorkExecutionContext;
import org.hibernate.search.elasticsearch.work.impl.factory.ElasticsearchWorkFactory;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.exception.impl.ErrorContextBuilder;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.util.impl.CollectionHelper;
import org.hibernate.search.util.impl.Executors;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class ElasticsearchWorkProcessor
implements AutoCloseable {
    private static final Log LOG = (Log)LoggerFactory.make(Log.class);
    private static final int MAX_BULK_SIZE = 250;
    private final AsyncBackendRequestProcessor asyncProcessor = new AsyncBackendRequestProcessor();
    private final ErrorHandler errorHandler;
    private final ElasticsearchClient client;
    private final GsonProvider gsonProvider;
    private final ElasticsearchWorkFactory workFactory;
    private final ElasticsearchWorkExecutionContext parallelWorkExecutionContext;

    public ElasticsearchWorkProcessor(BuildContext context, ElasticsearchClient client, GsonProvider gsonProvider, ElasticsearchWorkFactory workFactory) {
        this.errorHandler = context.getErrorHandler();
        this.client = client;
        this.gsonProvider = gsonProvider;
        this.workFactory = workFactory;
        this.parallelWorkExecutionContext = new ParallelWorkExecutionContext(client, gsonProvider);
    }

    @Override
    public void close() {
        this.awaitAsyncProcessingCompletion();
        this.asyncProcessor.shutdown();
    }

    public <T> T executeSyncUnsafe(ElasticsearchWork<T> work) {
        return work.execute(this.parallelWorkExecutionContext);
    }

    public void executeSyncSafe(Iterable<ElasticsearchWork<?>> works) {
        SequentialWorkExecutionContext context = new SequentialWorkExecutionContext(this.client, this.gsonProvider, this.workFactory, this, this.errorHandler);
        this.executeSafe(context, works, true);
        context.flush();
    }

    public void executeAsync(ElasticsearchWork<?> work) {
        this.asyncProcessor.submit(Collections.singleton(work));
    }

    public void executeAsync(List<ElasticsearchWork<?>> works) {
        this.asyncProcessor.submit(works);
    }

    public void awaitAsyncProcessingCompletion() {
        this.asyncProcessor.awaitCompletion();
    }

    private void executeSafe(SequentialWorkExecutionContext context, Iterable<ElasticsearchWork<?>> nonBulkedWorks, boolean refreshInBulkAPICall) {
        ErrorContextBuilder errorContextBuilder = new ErrorContextBuilder();
        for (ElasticsearchWork<?> work : this.createRequestGroups(nonBulkedWorks, refreshInBulkAPICall)) {
            try {
                this.executeUnsafe(work, context);
                work.getLuceneWorks().forEach(arg_0 -> ((ErrorContextBuilder)errorContextBuilder).workCompleted(arg_0));
            }
            catch (BulkRequestFailedException brfe) {
                brfe.getSuccessfulItems().keySet().stream().flatMap(ElasticsearchWork::getLuceneWorks).forEach(arg_0 -> ((ErrorContextBuilder)errorContextBuilder).workCompleted(arg_0));
                this.handleError(errorContextBuilder, (Throwable)((Object)brfe), nonBulkedWorks, brfe.getErroneousItems().stream().flatMap(ElasticsearchWork::getLuceneWorks));
                break;
            }
            catch (RuntimeException e) {
                this.handleError(errorContextBuilder, e, nonBulkedWorks, work.getLuceneWorks());
                break;
            }
        }
    }

    private void executeUnsafe(ElasticsearchWork<?> work, ElasticsearchWorkExecutionContext context) {
        if (LOG.isTraceEnabled()) {
            LOG.tracef("Processing %s", work);
        }
        work.execute(context);
    }

    private void handleError(ErrorContextBuilder errorContextBuilder, Throwable e, Iterable<ElasticsearchWork<?>> allWorks, Stream<LuceneWork> worksThatFailed) {
        errorContextBuilder.allWorkToBeDone((Iterable)StreamSupport.stream(allWorks.spliterator(), false).flatMap(w -> w.getLuceneWorks()).collect(Collectors.toList()));
        worksThatFailed.forEach(arg_0 -> ((ErrorContextBuilder)errorContextBuilder).addWorkThatFailed(arg_0));
        errorContextBuilder.errorThatOccurred(e);
        this.errorHandler.handle(errorContextBuilder.createErrorContext());
    }

    private List<ElasticsearchWork<?>> createRequestGroups(Iterable<ElasticsearchWork<?>> requests, boolean refreshInBulkAPICall) {
        ProcessorWorkGroupBuilder bulkBuilder = new ProcessorWorkGroupBuilder(refreshInBulkAPICall);
        for (ElasticsearchWork<?> request : requests) {
            request.aggregate(bulkBuilder);
        }
        return bulkBuilder.build();
    }

    private class ProcessorWorkGroupBuilder
    implements ElasticsearchWorkAggregator {
        private final boolean refreshInBulkAPICall;
        private final List<ElasticsearchWork<?>> result = new ArrayList();
        private final List<BulkableElasticsearchWork<?>> bulkInProgress = new ArrayList();

        public ProcessorWorkGroupBuilder(boolean refreshInBulkAPICall) {
            this.refreshInBulkAPICall = refreshInBulkAPICall;
        }

        @Override
        public void addBulkable(BulkableElasticsearchWork<?> work) {
            this.bulkInProgress.add(work);
            if (this.bulkInProgress.size() >= 250) {
                this.flushBulkInProgress();
            }
        }

        @Override
        public void addNonBulkable(ElasticsearchWork<?> work) {
            this.flushBulkInProgress();
            this.result.add(work);
        }

        private void flushBulkInProgress() {
            if (this.bulkInProgress.isEmpty()) {
                return;
            }
            if (this.bulkInProgress.size() == 1) {
                ElasticsearchWork work = this.bulkInProgress.iterator().next();
                this.result.add(work);
            } else {
                this.result.add((ElasticsearchWork<?>)ElasticsearchWorkProcessor.this.workFactory.bulk(this.bulkInProgress).refresh(this.refreshInBulkAPICall).build());
            }
            this.bulkInProgress.clear();
        }

        private List<ElasticsearchWork<?>> build() {
            this.flushBulkInProgress();
            return this.result;
        }
    }

    private class RequestProcessingRunnable
    implements Runnable {
        private final AsyncBackendRequestProcessor asyncProcessor;
        private final CountDownLatch latch = new CountDownLatch(1);

        public RequestProcessingRunnable(AsyncBackendRequestProcessor asyncProcessor) {
            this.asyncProcessor = asyncProcessor;
        }

        @Override
        public void run() {
            try {
                this.processAsyncWork();
            }
            finally {
                this.latch.countDown();
            }
        }

        private void processAsyncWork() {
            SequentialWorkExecutionContext context = new SequentialWorkExecutionContext(ElasticsearchWorkProcessor.this.client, ElasticsearchWorkProcessor.this.gsonProvider, ElasticsearchWorkProcessor.this.workFactory, ElasticsearchWorkProcessor.this, ElasticsearchWorkProcessor.this.errorHandler);
            AsyncBackendRequestProcessor asyncBackendRequestProcessor = this.asyncProcessor;
            synchronized (asyncBackendRequestProcessor) {
                while (true) {
                    Iterable works;
                    if ((works = this.asyncProcessor.asyncWorkQueue.drainToDetachedIterable()) == null) {
                        this.asyncProcessor.asyncWorkerWasStarted.set(false);
                        context.flush();
                        return;
                    }
                    Iterable flattenedWorks = CollectionHelper.flatten((Iterable)works);
                    ElasticsearchWorkProcessor.this.executeSafe(context, flattenedWorks, false);
                }
            }
        }
    }

    private class AsyncBackendRequestProcessor {
        private final ScheduledExecutorService scheduler;
        private final MultiWriteDrainableLinkedList<Iterable<ElasticsearchWork<?>>> asyncWorkQueue = new MultiWriteDrainableLinkedList();
        private final AtomicBoolean asyncWorkerWasStarted;
        private volatile CountDownLatch lastAsyncWorkLatch;

        private AsyncBackendRequestProcessor() {
            this.scheduler = Executors.newScheduledThreadPool((String)"Elasticsearch AsyncBackendRequestProcessor");
            this.asyncWorkerWasStarted = new AtomicBoolean(false);
        }

        public void submit(Iterable<ElasticsearchWork<?>> works) {
            this.asyncWorkQueue.add(works);
            this.ensureStarted();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void ensureStarted() {
            if (!this.asyncWorkerWasStarted.get()) {
                AsyncBackendRequestProcessor asyncBackendRequestProcessor = this;
                synchronized (asyncBackendRequestProcessor) {
                    if (this.asyncWorkerWasStarted.compareAndSet(false, true)) {
                        try {
                            RequestProcessingRunnable runnable = new RequestProcessingRunnable(this);
                            this.scheduler.schedule(runnable, 100L, TimeUnit.MILLISECONDS);
                            this.lastAsyncWorkLatch = runnable.latch;
                        }
                        catch (Exception e) {
                            this.asyncWorkerWasStarted.set(false);
                            CountDownLatch latch = this.lastAsyncWorkLatch;
                            if (latch != null) {
                                latch.countDown();
                            }
                            throw e;
                        }
                    }
                }
            }
        }

        public void awaitCompletion() {
            CountDownLatch localLatch = this.lastAsyncWorkLatch;
            if (localLatch != null) {
                try {
                    localLatch.await();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw LOG.interruptedWhileWaitingForRequestCompletion(e);
                }
            }
        }

        public void shutdown() {
            this.scheduler.shutdown();
            try {
                this.scheduler.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                LOG.interruptedWhileWaitingForIndexActivity(e);
            }
            finally {
                CountDownLatch localLatch = this.lastAsyncWorkLatch;
                if (localLatch != null) {
                    localLatch.countDown();
                }
            }
        }
    }
}

