/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.work.impl;

import java.util.HashSet;
import java.util.Set;
import org.hibernate.search.elasticsearch.client.impl.ElasticsearchRequest;
import org.hibernate.search.elasticsearch.client.impl.ElasticsearchResponse;
import org.hibernate.search.elasticsearch.client.impl.Paths;
import org.hibernate.search.elasticsearch.client.impl.URLEncodedString;
import org.hibernate.search.elasticsearch.work.impl.DefaultElasticsearchRequestSuccessAssessor;
import org.hibernate.search.elasticsearch.work.impl.ElasticsearchWork;
import org.hibernate.search.elasticsearch.work.impl.ElasticsearchWorkExecutionContext;
import org.hibernate.search.elasticsearch.work.impl.SimpleElasticsearchWork;
import org.hibernate.search.elasticsearch.work.impl.builder.FlushWorkBuilder;
import org.hibernate.search.elasticsearch.work.impl.builder.RefreshWorkBuilder;
import org.hibernate.search.elasticsearch.work.impl.factory.ElasticsearchWorkFactory;

public class ES5FlushWork
extends SimpleElasticsearchWork<Void> {
    private final ElasticsearchWork<?> refreshWork;

    protected ES5FlushWork(Builder builder) {
        super(builder);
        this.refreshWork = builder.buildRefreshWork();
    }

    @Override
    protected void afterSuccess(ElasticsearchWorkExecutionContext executionContext) {
        super.afterSuccess(executionContext);
        this.refreshWork.execute(executionContext);
    }

    @Override
    protected Void generateResult(ElasticsearchWorkExecutionContext context, ElasticsearchResponse response) {
        return null;
    }

    public static class Builder
    extends SimpleElasticsearchWork.Builder<Builder>
    implements FlushWorkBuilder {
        private final RefreshWorkBuilder refreshWorkBuilder;
        private final Set<URLEncodedString> indexNames = new HashSet<URLEncodedString>();

        public Builder(ElasticsearchWorkFactory workFactory) {
            super(null, DefaultElasticsearchRequestSuccessAssessor.INSTANCE);
            this.refreshWorkBuilder = workFactory.refresh();
        }

        @Override
        public Builder index(URLEncodedString indexName) {
            this.indexNames.add(indexName);
            this.refreshWorkBuilder.index(indexName);
            return this;
        }

        @Override
        protected ElasticsearchRequest buildRequest() {
            ElasticsearchRequest.Builder builder = ElasticsearchRequest.post();
            if (!this.indexNames.isEmpty()) {
                builder.multiValuedPathComponent(this.indexNames);
            }
            builder.pathComponent(Paths._FLUSH);
            return builder.build();
        }

        protected ElasticsearchWork<?> buildRefreshWork() {
            return this.refreshWorkBuilder.build();
        }

        @Override
        public ES5FlushWork build() {
            return new ES5FlushWork(this);
        }
    }
}

