/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.work.impl;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import org.hibernate.search.elasticsearch.client.impl.ElasticsearchRequest;
import org.hibernate.search.elasticsearch.client.impl.ElasticsearchResponse;
import org.hibernate.search.elasticsearch.client.impl.Paths;
import org.hibernate.search.elasticsearch.client.impl.URLEncodedString;
import org.hibernate.search.elasticsearch.gson.impl.GsonProvider;
import org.hibernate.search.elasticsearch.settings.impl.model.IndexSettings;
import org.hibernate.search.elasticsearch.work.impl.DefaultElasticsearchRequestSuccessAssessor;
import org.hibernate.search.elasticsearch.work.impl.ElasticsearchWorkExecutionContext;
import org.hibernate.search.elasticsearch.work.impl.SimpleElasticsearchWork;
import org.hibernate.search.elasticsearch.work.impl.builder.PutIndexSettingsWorkBuilder;

public class PutIndexSettingsWork
extends SimpleElasticsearchWork<Void> {
    protected PutIndexSettingsWork(Builder builder) {
        super(builder);
    }

    @Override
    protected Void generateResult(ElasticsearchWorkExecutionContext context, ElasticsearchResponse response) {
        return null;
    }

    public static class Builder
    extends SimpleElasticsearchWork.Builder<Builder>
    implements PutIndexSettingsWorkBuilder {
        private final URLEncodedString indexName;
        private final JsonObject payload;

        public Builder(GsonProvider gsonProvider, URLEncodedString indexName, IndexSettings settings) {
            super(null, DefaultElasticsearchRequestSuccessAssessor.INSTANCE);
            this.indexName = indexName;
            Gson gson = gsonProvider.getGsonNoSerializeNulls();
            this.payload = gson.toJsonTree((Object)settings).getAsJsonObject();
        }

        @Override
        protected ElasticsearchRequest buildRequest() {
            ElasticsearchRequest.Builder builder = ElasticsearchRequest.put().pathComponent(this.indexName).pathComponent(Paths._SETTINGS).body(this.payload);
            return builder.build();
        }

        @Override
        public PutIndexSettingsWork build() {
            return new PutIndexSettingsWork(this);
        }
    }
}

