/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.work.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.search.elasticsearch.client.impl.ElasticsearchRequest;
import org.hibernate.search.elasticsearch.client.impl.ElasticsearchResponse;
import org.hibernate.search.elasticsearch.client.impl.Paths;
import org.hibernate.search.elasticsearch.client.impl.URLEncodedString;
import org.hibernate.search.elasticsearch.gson.impl.GsonProvider;
import org.hibernate.search.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.elasticsearch.util.impl.ElasticsearchClientUtils;
import org.hibernate.search.elasticsearch.work.impl.DefaultElasticsearchRequestSuccessAssessor;
import org.hibernate.search.elasticsearch.work.impl.ElasticsearchWork;
import org.hibernate.search.elasticsearch.work.impl.ElasticsearchWorkExecutionContext;
import org.hibernate.search.elasticsearch.work.impl.SearchResult;
import org.hibernate.search.elasticsearch.work.impl.SimpleElasticsearchWork;
import org.hibernate.search.elasticsearch.work.impl.builder.SearchWorkBuilder;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.util.logging.impl.DefaultLogCategories;
import org.hibernate.search.util.logging.impl.LogCategory;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class SearchWork
extends SimpleElasticsearchWork<SearchResult> {
    private static final Log QUERY_LOG = (Log)LoggerFactory.make(Log.class, (LogCategory)DefaultLogCategories.QUERY);

    protected SearchWork(Builder builder) {
        super(builder);
    }

    @Override
    protected void beforeExecute(ElasticsearchWorkExecutionContext executionContext, ElasticsearchRequest request) {
        if (QUERY_LOG.isDebugEnabled()) {
            GsonProvider gsonProvider = executionContext.getGsonProvider();
            QUERY_LOG.executingElasticsearchQuery(request.getPath(), request.getParameters(), ElasticsearchClientUtils.formatRequestData(gsonProvider, request));
        }
    }

    @Override
    protected SearchResult generateResult(ElasticsearchWorkExecutionContext context, ElasticsearchResponse response) {
        JsonObject body = response.getBody();
        return new SearchResultImpl(body);
    }

    static class SearchResultImpl
    implements SearchResult {
        private static final JsonAccessor<JsonArray> HITS_HITS_ACCESSOR = JsonAccessor.root().property("hits").property("hits").asArray();
        private static final JsonAccessor<Integer> COUNT_ACCESSOR = JsonAccessor.root().property("hits").property("total").asInteger();
        private static final JsonAccessor<JsonObject> AGGREGATIONS_ACCESSOR = JsonAccessor.root().property("aggregations").asObject();
        private static final JsonAccessor<Integer> TOOK_ACCESSOR = JsonAccessor.root().property("took").asInteger();
        private static final JsonAccessor<Boolean> TIMED_OUT_ACCESSOR = JsonAccessor.root().property("timed_out").asBoolean();
        private static final JsonAccessor<String> SCROLL_ID_ACCESSOR = JsonAccessor.root().property("_scroll_id").asString();
        private final JsonObject jsonObject;

        public SearchResultImpl(JsonObject jsonObject) {
            this.jsonObject = jsonObject;
        }

        @Override
        public JsonArray getHits() {
            return HITS_HITS_ACCESSOR.get(this.jsonObject).orElseGet(JsonArray::new);
        }

        @Override
        public int getTotalHitCount() {
            return COUNT_ACCESSOR.get(this.jsonObject).orElse(0);
        }

        @Override
        public JsonObject getAggregations() {
            return AGGREGATIONS_ACCESSOR.get(this.jsonObject).orElseGet(JsonObject::new);
        }

        @Override
        public int getTook() {
            return TOOK_ACCESSOR.get(this.jsonObject).orElseThrow(() -> new AssertionFailure("Elasticsearch response lacked a value for '" + TOOK_ACCESSOR.getStaticAbsolutePath() + "'"));
        }

        @Override
        public boolean getTimedOut() {
            return TIMED_OUT_ACCESSOR.get(this.jsonObject).orElseThrow(() -> new AssertionFailure("Elasticsearch response lacked a value for '" + TIMED_OUT_ACCESSOR.getStaticAbsolutePath() + "'"));
        }

        @Override
        public String getScrollId() {
            return SCROLL_ID_ACCESSOR.get(this.jsonObject).orElseThrow(() -> new AssertionFailure("Elasticsearch response lacked a value for '" + SCROLL_ID_ACCESSOR.getStaticAbsolutePath() + "'"));
        }
    }

    public static class Builder
    extends SimpleElasticsearchWork.Builder<Builder>
    implements SearchWorkBuilder {
        private final JsonObject payload;
        private final Set<URLEncodedString> indexes = new HashSet<URLEncodedString>();
        private Integer from;
        private Integer size;
        private Integer scrollSize;
        private String scrollTimeout;

        public Builder(JsonObject payload) {
            super(null, DefaultElasticsearchRequestSuccessAssessor.INSTANCE);
            this.payload = payload;
        }

        @Override
        public Builder indexes(Collection<URLEncodedString> indexNames) {
            this.indexes.addAll(indexNames);
            return this;
        }

        @Override
        public Builder paging(int firstResult, int size) {
            this.from = firstResult;
            this.size = size;
            return this;
        }

        @Override
        public Builder scrolling(int scrollSize, String scrollTimeout) {
            this.scrollSize = scrollSize;
            this.scrollTimeout = scrollTimeout;
            return this;
        }

        @Override
        protected ElasticsearchRequest buildRequest() {
            ElasticsearchRequest.Builder builder = ElasticsearchRequest.post().multiValuedPathComponent(this.indexes).pathComponent(Paths._SEARCH).body(this.payload);
            if (this.from != null && this.size != null) {
                builder.param("from", this.from);
                builder.param("size", this.size);
            }
            if (this.scrollSize != null && this.scrollTimeout != null) {
                builder.param("size", this.scrollSize);
                builder.param("scroll", this.scrollTimeout);
            }
            return builder.build();
        }

        @Override
        public ElasticsearchWork<SearchResult> build() {
            return new SearchWork(this);
        }
    }
}

