/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.operations.mediatypes.impl;

import java.io.IOException;
import java.io.Serializable;
import java.util.stream.Collectors;
import org.infinispan.CacheSet;
import org.infinispan.rest.operations.exceptions.ServerInternalException;
import org.infinispan.rest.operations.mediatypes.Charset;
import org.infinispan.rest.operations.mediatypes.OutputPrinter;
import org.infinispan.rest.operations.mediatypes.impl.SerializationUtil;
import org.infinispan.stream.CacheCollectors;
import org.infinispan.util.function.SerializableFunction;
import org.infinispan.util.function.SerializableSupplier;

public class BinaryOutputPrinter
implements OutputPrinter {
    @Override
    public byte[] print(String cacheName, CacheSet<?> keys, Charset charset) {
        return ((String)keys.stream().map((SerializableFunction & Serializable)b -> b.toString()).collect(CacheCollectors.serializableCollector((SerializableSupplier & Serializable)() -> Collectors.joining(",", "[", "]")))).getBytes(charset.getJavaCharset());
    }

    @Override
    public byte[] print(Object value, Charset charset) throws ServerInternalException {
        if (value instanceof byte[]) {
            return (byte[])value;
        }
        if (value instanceof Serializable) {
            try {
                return SerializationUtil.toByteArray(value);
            }
            catch (IOException e) {
                throw new ServerInternalException(e);
            }
        }
        return value.toString().getBytes(charset.getJavaCharset());
    }
}

