/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.endpoint.subsystem;

import org.infinispan.server.core.ProtocolServer;
import org.infinispan.server.core.configuration.ProtocolServerConfigurationBuilder;
import org.infinispan.server.endpoint.Constants;
import org.infinispan.server.endpoint.subsystem.AuthenticationResource;
import org.infinispan.server.endpoint.subsystem.EncryptableSubsystemHelper;
import org.infinispan.server.endpoint.subsystem.EndpointUtils;
import org.infinispan.server.endpoint.subsystem.ExtensionManagerService;
import org.infinispan.server.endpoint.subsystem.ProtocolServerConnectorResource;
import org.infinispan.server.endpoint.subsystem.ProtocolServerService;
import org.infinispan.server.endpoint.subsystem.ProtocolServiceSubsystemAdd;
import org.infinispan.server.endpoint.subsystem.SaslResource;
import org.infinispan.server.endpoint.subsystem.TopologyStateTransferResource;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.configuration.AuthenticationConfigurationBuilder;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;

class HotRodSubsystemAdd
extends ProtocolServiceSubsystemAdd {
    static final ProtocolServiceSubsystemAdd INSTANCE = new HotRodSubsystemAdd();

    HotRodSubsystemAdd() {
    }

    protected void populateModel(ModelNode source, ModelNode target) throws OperationFailedException {
        HotRodSubsystemAdd.populate(source, target);
    }

    private static void populate(ModelNode source, ModelNode target) throws OperationFailedException {
        for (SimpleAttributeDefinition simpleAttributeDefinition : ProtocolServerConnectorResource.COMMON_CONNECTOR_ATTRIBUTES) {
            simpleAttributeDefinition.validateAndSet(source, target);
        }
        for (SimpleAttributeDefinition simpleAttributeDefinition : ProtocolServerConnectorResource.COMMON_LIST_CONNECTOR_ATTRIBUTES) {
            simpleAttributeDefinition.validateAndSet(source, target);
        }
        for (SimpleAttributeDefinition simpleAttributeDefinition : ProtocolServerConnectorResource.PROTOCOL_SERVICE_ATTRIBUTES) {
            simpleAttributeDefinition.validateAndSet(source, target);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        ModelNode config = Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS));
        HotRodServerConfigurationBuilder configurationBuilder = new HotRodServerConfigurationBuilder();
        this.configureProtocolServer((ProtocolServerConfigurationBuilder<?, ?>)configurationBuilder, config);
        this.configureProtocolServerTopology(context, configurationBuilder, config);
        ProtocolServerService service = new ProtocolServerService(this.getServiceName(operation), (Class<? extends ProtocolServer>)HotRodServer.class, (ProtocolServerConfigurationBuilder<?, ?>)configurationBuilder);
        ServiceName hotRodServerServiceName = EndpointUtils.getServiceName(operation, "hotrod");
        ServiceBuilder builder = context.getServiceTarget().addService(hotRodServerServiceName, (Service)service);
        String cacheContainerName = this.getCacheContainerName(operation);
        EndpointUtils.addCacheContainerConfigurationDependency(builder, cacheContainerName, service.getCacheManagerConfiguration());
        EndpointUtils.addCacheContainerDependency(builder, cacheContainerName, service.getCacheManager());
        EndpointUtils.addCacheDependency(builder, cacheContainerName, null);
        EndpointUtils.addSocketBindingDependency(context, builder, this.getSocketBindingName(operation), service.getSocketBinding());
        EncryptableSubsystemHelper.processEncryption((ExpressionResolver)context, config, service, builder);
        this.processAuthentication(context, configurationBuilder, service, builder, config);
        builder.addDependency(Constants.EXTENSION_MANAGER_NAME, ExtensionManagerService.class, service.getExtensionManager());
        builder.install();
    }

    private void processAuthentication(OperationContext context, HotRodServerConfigurationBuilder configurationBuilder, ProtocolServerService service, ServiceBuilder<?> builder, ModelNode config) throws OperationFailedException {
        if (config.hasDefined("authentication") && config.get(new String[]{"authentication", "AUTHENTICATION"}).isDefined()) {
            configurationBuilder.authentication().enable();
            ModelNode authentication = config.get(new String[]{"authentication", "AUTHENTICATION"});
            EndpointUtils.addSecurityRealmDependency(builder, AuthenticationResource.SECURITY_REALM.resolveModelAttribute(context, authentication).asString(), service.getAuthenticationSecurityRealm());
            if (authentication.hasDefined("sasl") && authentication.get(new String[]{"sasl", "SASL"}).isDefined()) {
                String strength;
                String qop;
                AuthenticationConfigurationBuilder authenticationBuilder = configurationBuilder.authentication();
                ModelNode sasl = authentication.get(new String[]{"sasl", "SASL"});
                if (sasl.hasDefined("server-context-name")) {
                    String serverContextName = SaslResource.SERVER_CONTEXT_NAME.resolveModelAttribute(context, sasl).asString();
                    service.setServerContextName(serverContextName);
                    EndpointUtils.addSecurityDomainDependency(builder, serverContextName, service.getSaslSecurityDomain());
                }
                if (sasl.hasDefined("server-name")) {
                    authenticationBuilder.serverName(SaslResource.SERVER_NAME.resolveModelAttribute(context, sasl).asString());
                }
                if (sasl.hasDefined("mechanisms")) {
                    for (ModelNode mech : sasl.get("mechanisms").asList()) {
                        authenticationBuilder.addAllowedMech(mech.asString());
                    }
                }
                if ((qop = this.listAsString(sasl, "qop")) != null) {
                    authenticationBuilder.addMechProperty("javax.security.sasl.qop", qop);
                }
                if ((strength = this.listAsString(sasl, "strength")) != null) {
                    authenticationBuilder.addMechProperty("javax.security.sasl.strength", strength);
                }
                if (sasl.hasDefined("sasl-policy") && sasl.get(new String[]{"sasl-policy", "SASL_POLICY"}).isDefined()) {
                    for (Property property : sasl.get(new String[]{"sasl-policy", "SASL_POLICY"}).asPropertyList()) {
                        String value = property.getValue().asString();
                        switch (property.getName()) {
                            case "forward-secrecy": {
                                authenticationBuilder.addMechProperty("javax.security.sasl.policy.forward", value);
                                break;
                            }
                            case "no-active": {
                                authenticationBuilder.addMechProperty("javax.security.sasl.policy.noactive", value);
                                break;
                            }
                            case "no-anonymous": {
                                authenticationBuilder.addMechProperty("javax.security.sasl.policy.noanonymous", value);
                                break;
                            }
                            case "no-dictionary": {
                                authenticationBuilder.addMechProperty("javax.security.sasl.policy.nodictionary", value);
                                break;
                            }
                            case "no-plain-text": {
                                authenticationBuilder.addMechProperty("javax.security.sasl.policy.noplaintext", value);
                                break;
                            }
                            case "pass-credentials": {
                                authenticationBuilder.addMechProperty("javax.security.sasl.policy.credentials", value);
                            }
                        }
                    }
                }
                if (sasl.hasDefined("property")) {
                    for (Property property : sasl.get("property").asPropertyList()) {
                        authenticationBuilder.addMechProperty(property.getName(), property.getValue().asProperty().getValue().asString());
                    }
                }
            }
        }
    }

    private String listAsString(ModelNode node, String name) {
        if (node.hasDefined(name)) {
            StringBuilder sb = new StringBuilder();
            for (ModelNode item : node.get(name).asList()) {
                if (sb.length() > 0) {
                    sb.append(' ');
                }
                sb.append(item.asString());
            }
            return sb.toString();
        }
        return null;
    }

    private void configureProtocolServerTopology(OperationContext context, HotRodServerConfigurationBuilder builder, ModelNode config) throws OperationFailedException {
        if (config.hasDefined("topology-state-transfer") && config.get(new String[]{"topology-state-transfer", "TOPOLOGY_STATE_TRANSFER"}).isDefined()) {
            if ((config = config.get(new String[]{"topology-state-transfer", "TOPOLOGY_STATE_TRANSFER"})).hasDefined("lock-timeout")) {
                builder.topologyLockTimeout(TopologyStateTransferResource.LOCK_TIMEOUT.resolveModelAttribute(context, config).asLong());
            }
            if (config.hasDefined("replication-timeout")) {
                builder.topologyReplTimeout(TopologyStateTransferResource.REPLICATION_TIMEOUT.resolveModelAttribute(context, config).asLong());
            }
            if (config.hasDefined("external-host")) {
                builder.proxyHost(TopologyStateTransferResource.EXTERNAL_HOST.resolveModelAttribute(context, config).asString());
            }
            if (config.hasDefined("external-port")) {
                builder.proxyPort(TopologyStateTransferResource.EXTERNAL_PORT.resolveModelAttribute(context, config).asInt());
            }
            if (config.hasDefined("lazy-retrieval")) {
                builder.topologyStateTransfer(!TopologyStateTransferResource.LAZY_RETRIEVAL.resolveModelAttribute(context, config).asBoolean());
            }
            if (config.hasDefined("await-initial-retrieval")) {
                builder.topologyAwaitInitialTransfer(TopologyStateTransferResource.AWAIT_INITIAL_RETRIEVAL.resolveModelAttribute(context, config).asBoolean());
            }
        }
    }

    protected boolean requiresRuntimeVerification() {
        return false;
    }
}

