/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.endpoint.subsystem;

import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.rest.RestServer;
import org.infinispan.rest.authentication.Authenticator;
import org.infinispan.rest.authentication.SecurityDomain;
import org.infinispan.rest.authentication.impl.BasicAuthenticator;
import org.infinispan.rest.authentication.impl.ClientCertAuthenticator;
import org.infinispan.rest.authentication.impl.VoidAuthenticator;
import org.infinispan.rest.configuration.ExtendedHeaders;
import org.infinispan.rest.configuration.RestServerConfigurationBuilder;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.endpoint.EndpointLogger;
import org.infinispan.server.endpoint.subsystem.EncryptableService;
import org.infinispan.server.endpoint.subsystem.EncryptableServiceHelper;
import org.infinispan.server.endpoint.subsystem.RestAuthMethod;
import org.infinispan.server.endpoint.subsystem.security.BasicRestSecurityDomain;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.network.SocketBinding;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class RestService
implements Service<RestServer>,
EncryptableService {
    private final InjectedValue<PathManager> pathManagerInjector = new InjectedValue();
    private final InjectedValue<EmbeddedCacheManager> cacheManagerInjector = new InjectedValue();
    private final InjectedValue<SocketBinding> socketBinding = new InjectedValue();
    private final InjectedValue<SecurityRealm> encryptionSecurityRealm = new InjectedValue();
    private final InjectedValue<SecurityRealm> authenticationSecurityRealm = new InjectedValue();
    private final Map<String, InjectedValue<SecurityRealm>> sniDomains = new HashMap<String, InjectedValue<SecurityRealm>>();
    private final RestAuthMethod authMethod;
    private final String serverName;
    private final String contextPath;
    private final ExtendedHeaders extendedHeaders;
    private final Set<String> ignoredCaches;
    private RestServer restServer;
    private boolean clientAuth;

    public RestService(String serverName, RestAuthMethod authMethod, String contextPath, ExtendedHeaders extendedHeaders, Set<String> ignoredCaches) {
        this.serverName = serverName;
        this.authMethod = authMethod;
        this.contextPath = contextPath;
        this.extendedHeaders = extendedHeaders;
        this.ignoredCaches = ignoredCaches;
    }

    public synchronized void start(StartContext startContext) throws StartException {
        RestServerConfigurationBuilder builder = new RestServerConfigurationBuilder();
        ((RestServerConfigurationBuilder)((RestServerConfigurationBuilder)builder.name(this.serverName)).extendedHeaders(this.extendedHeaders).ignoredCaches(this.ignoredCaches)).contextPath(this.contextPath);
        EncryptableServiceHelper.fillSecurityConfiguration(this, builder.ssl());
        String protocolName = this.getProtocolName();
        EndpointLogger.ROOT_LOGGER.endpointStarting(this.serverName);
        try {
            VoidAuthenticator authenticator;
            SocketBinding socketBinding = (SocketBinding)this.getSocketBinding().getOptionalValue();
            if (socketBinding == null) {
                builder.startTransport(false);
                EndpointLogger.ROOT_LOGGER.startingServerWithoutTransport("REST");
            } else {
                InetSocketAddress socketAddress = socketBinding.getSocketAddress();
                builder.host(socketAddress.getAddress().getHostAddress());
                builder.port(socketAddress.getPort());
            }
            switch (this.authMethod) {
                case BASIC: {
                    SecurityRealm authenticationRealm = (SecurityRealm)this.authenticationSecurityRealm.getOptionalValue();
                    BasicRestSecurityDomain restSecurityDomain = new BasicRestSecurityDomain(authenticationRealm);
                    authenticator = new BasicAuthenticator((SecurityDomain)restSecurityDomain, authenticationRealm.getName());
                    break;
                }
                case CLIENT_CERT: {
                    if (!EncryptableServiceHelper.isSecurityEnabled(this)) {
                        throw EndpointLogger.ROOT_LOGGER.cannotUseCertificateAuthenticationWithoutEncryption();
                    }
                    authenticator = new ClientCertAuthenticator();
                    break;
                }
                case NONE: {
                    authenticator = new VoidAuthenticator();
                    break;
                }
                default: {
                    throw EndpointLogger.ROOT_LOGGER.restAuthMethodUnsupported(this.authMethod.toString());
                }
            }
            this.restServer = new RestServer();
            this.restServer.setAuthenticator((Authenticator)authenticator);
        }
        catch (Exception e) {
            throw EndpointLogger.ROOT_LOGGER.restContextCreationFailed(e);
        }
        try {
            this.restServer.start((ProtocolServerConfiguration)builder.build(), (EmbeddedCacheManager)this.cacheManagerInjector.getValue());
            EndpointLogger.ROOT_LOGGER.httpEndpointStarted(protocolName, this.restServer.getHost() + ":" + this.restServer.getPort(), this.contextPath);
        }
        catch (Exception e) {
            throw EndpointLogger.ROOT_LOGGER.restContextStartFailed(e);
        }
    }

    private String getProtocolName() {
        return EncryptableServiceHelper.isSecurityEnabled(this) ? (EncryptableServiceHelper.isSniEnabled(this) ? this.serverName + " (TLS/SNI)" : this.serverName + " (TLS)") : this.serverName;
    }

    public synchronized void stop(StopContext stopContext) {
        this.restServer.stop();
    }

    public synchronized RestServer getValue() throws IllegalStateException {
        if (this.restServer == null) {
            throw new IllegalStateException();
        }
        return this.restServer;
    }

    public InjectedValue<PathManager> getPathManagerInjector() {
        return this.pathManagerInjector;
    }

    public InjectedValue<EmbeddedCacheManager> getCacheManager() {
        return this.cacheManagerInjector;
    }

    public InjectedValue<SecurityRealm> getAuthenticationSecurityRealm() {
        return this.authenticationSecurityRealm;
    }

    public InjectedValue<SocketBinding> getSocketBinding() {
        return this.socketBinding;
    }

    @Override
    public InjectedValue<SecurityRealm> getEncryptionSecurityRealm() {
        return this.encryptionSecurityRealm;
    }

    @Override
    public InjectedValue<SecurityRealm> getSniSecurityRealm(String sniHostName) {
        return this.sniDomains.computeIfAbsent(sniHostName, v -> new InjectedValue());
    }

    @Override
    public Map<String, InjectedValue<SecurityRealm>> getSniConfiguration() {
        return this.sniDomains;
    }

    @Override
    public String getServerName() {
        return this.serverName;
    }

    @Override
    public void setClientAuth(boolean enabled) {
        this.clientAuth = enabled;
    }

    @Override
    public boolean getClientAuth() {
        return this.clientAuth;
    }
}

