/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.iiop.openjdk.rmi;

import java.lang.reflect.Method;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.ArrayList;
import org.wildfly.iiop.openjdk.logging.IIOPLogger;
import org.wildfly.iiop.openjdk.rmi.AbstractAnalysis;
import org.wildfly.iiop.openjdk.rmi.ExceptionAnalysis;
import org.wildfly.iiop.openjdk.rmi.ParameterAnalysis;
import org.wildfly.iiop.openjdk.rmi.RMIIIOPViolationException;
import org.wildfly.iiop.openjdk.rmi.Util;

public class OperationAnalysis
extends AbstractAnalysis {
    private final Method method;
    private final ExceptionAnalysis[] mappedExceptions;
    private final ParameterAnalysis[] parameters;

    OperationAnalysis(Method method) throws RMIIIOPViolationException {
        super(method.getName());
        this.method = method;
        Class<?> retCls = method.getReturnType();
        if (retCls.isInterface() && Remote.class.isAssignableFrom(retCls)) {
            Util.isValidRMIIIOP(retCls);
        }
        Class<?>[] ex = method.getExceptionTypes();
        boolean gotRemoteException = false;
        ArrayList<ExceptionAnalysis> a = new ArrayList<ExceptionAnalysis>();
        for (int i = 0; i < ex.length; ++i) {
            if (ex[i].isAssignableFrom(RemoteException.class)) {
                gotRemoteException = true;
            }
            if (!Exception.class.isAssignableFrom(ex[i]) || RuntimeException.class.isAssignableFrom(ex[i]) || RemoteException.class.isAssignableFrom(ex[i])) continue;
            a.add(ExceptionAnalysis.getExceptionAnalysis(ex[i]));
        }
        if (!gotRemoteException && Remote.class.isAssignableFrom(method.getDeclaringClass())) {
            throw IIOPLogger.ROOT_LOGGER.badRMIIIOPMethodSignature(this.getJavaName(), method.getDeclaringClass().getName(), "1.2.3");
        }
        ExceptionAnalysis[] exceptions = new ExceptionAnalysis[a.size()];
        this.mappedExceptions = a.toArray(exceptions);
        Class<?>[] params = method.getParameterTypes();
        this.parameters = new ParameterAnalysis[params.length];
        for (int i = 0; i < params.length; ++i) {
            this.parameters[i] = new ParameterAnalysis("param" + (i + 1), params[i]);
        }
    }

    public Class getReturnType() {
        return this.method.getReturnType();
    }

    public Method getMethod() {
        return this.method;
    }

    public ExceptionAnalysis[] getMappedExceptions() {
        return (ExceptionAnalysis[])this.mappedExceptions.clone();
    }

    public ParameterAnalysis[] getParameters() {
        return (ParameterAnalysis[])this.parameters.clone();
    }
}

