/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.jboss.as.clustering.infinispan.subsystem.FileStoreResource;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanSubsystemRootResource;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanSubsystemXMLReader;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanSubsystemXMLWriter;
import org.jboss.as.clustering.infinispan.subsystem.Namespace;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.services.path.ResolvePathHandler;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;

public class InfinispanExtension
implements Extension {
    public static final String SUBSYSTEM_NAME = "datagrid-infinispan";
    static final PathElement SUBSYSTEM_PATH = PathElement.pathElement((String)"subsystem", (String)"datagrid-infinispan");
    public static final String RESOURCE_NAME = InfinispanExtension.class.getPackage().getName() + ".LocalDescriptions";

    public void initialize(ExtensionContext context) {
        PathManager pathManager;
        ResolvePathHandler resolvePathHandler;
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME, Namespace.CURRENT.getVersion());
        if (context.getProcessType().isServer()) {
            resolvePathHandler = ResolvePathHandler.Builder.of((PathManager)context.getPathManager()).setPathAttribute((AttributeDefinition)FileStoreResource.PATH).setRelativeToAttribute((AttributeDefinition)FileStoreResource.RELATIVE_TO).build();
            pathManager = context.getPathManager();
        } else {
            resolvePathHandler = null;
            pathManager = null;
        }
        subsystem.registerSubsystemModel((ResourceDefinition)new InfinispanSubsystemRootResource(resolvePathHandler, pathManager, context.isRuntimeOnlyRegistrationValid()));
        subsystem.registerXMLElementWriter((XMLElementWriter)new InfinispanSubsystemXMLWriter());
    }

    public void initializeParsers(ExtensionParsingContext context) {
        for (Namespace namespace : Namespace.values()) {
            context.setSubsystemXmlMapping(SUBSYSTEM_NAME, namespace.getUri(), (XMLElementReader)new InfinispanSubsystemXMLReader(namespace));
        }
    }
}

