/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream.impl.termop.primitive;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.BaseStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.ImmortalCacheEntry;
import org.infinispan.stream.impl.KeyTrackingTerminalOperation;
import org.infinispan.stream.impl.intops.IntermediateOperation;
import org.infinispan.stream.impl.termop.BaseTerminalOperation;

public abstract class AbstractForEachLongOperation<K>
extends BaseTerminalOperation
implements KeyTrackingTerminalOperation<K, Long, K> {
    private final int batchSize;

    public AbstractForEachLongOperation(Iterable<IntermediateOperation> intermediateOperations, Supplier<Stream<CacheEntry>> supplier, int batchSize) {
        super(intermediateOperations, supplier);
        this.batchSize = batchSize;
    }

    @Override
    public boolean lostSegment(boolean stopIfLost) {
        return true;
    }

    @Override
    public List<Long> performOperation(KeyTrackingTerminalOperation.IntermediateCollector<Collection<Long>> response) {
        throw new UnsupportedOperationException();
    }

    protected abstract void handleArray(long[] var1, int var2);

    @Override
    public Collection<CacheEntry<K, K>> performOperationRehashAware(KeyTrackingTerminalOperation.IntermediateCollector<Collection<CacheEntry<K, K>>> response) {
        Object stream = ((BaseStream)this.supplier.get()).sequential();
        ArrayList<CacheEntry<K, K>> collectedValues = new ArrayList<CacheEntry<K, K>>(this.batchSize);
        long[] list = new long[this.batchSize];
        AtomicInteger offset = new AtomicInteger();
        Object[] currentKey = new Object[1];
        stream = ((Stream)stream).peek(e -> {
            if (offset.get() > 0) {
                collectedValues.add(new ImmortalCacheEntry(currentKey[0], currentKey[0]));
                if (collectedValues.size() >= this.batchSize) {
                    this.handleArray(list, offset.get());
                    response.sendDataResonse(collectedValues);
                    collectedValues.clear();
                    offset.set(0);
                }
            }
            currentKey[0] = e.getKey();
        });
        for (IntermediateOperation intermediateOperation : this.intermediateOperations) {
            stream = intermediateOperation.perform(stream);
        }
        LongStream convertedStream = (LongStream)stream;
        convertedStream.forEach(d -> {
            list[offset.getAndIncrement()] = d;
        });
        if (offset.get() > 0) {
            this.handleArray(list, offset.get());
            collectedValues.add(new ImmortalCacheEntry(currentKey[0], currentKey[0]));
        }
        return collectedValues;
    }

    public int getBatchSize() {
        return this.batchSize;
    }
}

