/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ThreadFactory;
import org.infinispan.Cache;
import org.jboss.as.server.deployment.Services;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.threads.JBossThreadFactory;
import org.wildfly.clustering.ee.infinispan.TransactionBatch;
import org.wildfly.clustering.ejb.BeanContext;
import org.wildfly.clustering.ejb.BeanManagerFactory;
import org.wildfly.clustering.ejb.BeanManagerFactoryBuilderConfiguration;
import org.wildfly.clustering.ejb.BeanManagerFactoryBuilderFactory;
import org.wildfly.clustering.ejb.infinispan.InfinispanBeanManager;
import org.wildfly.clustering.ejb.infinispan.InfinispanBeanManagerFactoryBuilder;
import org.wildfly.clustering.infinispan.spi.service.CacheBuilder;
import org.wildfly.clustering.infinispan.spi.service.TemplateConfigurationBuilder;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.service.concurrent.CachedThreadPoolExecutorServiceBuilder;
import org.wildfly.clustering.service.concurrent.RemoveOnCancelScheduledExecutorServiceBuilder;

public class InfinispanBeanManagerFactoryBuilderFactory<I>
implements BeanManagerFactoryBuilderFactory<I, TransactionBatch> {
    private static final ThreadFactory EXPIRATION_THREAD_FACTORY = InfinispanBeanManagerFactoryBuilderFactory.createThreadFactory();
    private static final ThreadFactory EVICTION_THREAD_FACTORY = InfinispanBeanManagerFactoryBuilderFactory.createThreadFactory();
    private final String name;
    private final BeanManagerFactoryBuilderConfiguration config;

    private static ThreadFactory createThreadFactory() {
        return AccessController.doPrivileged(new PrivilegedAction<ThreadFactory>(){

            @Override
            public ThreadFactory run() {
                return new JBossThreadFactory(new ThreadGroup(InfinispanBeanManager.class.getSimpleName()), Boolean.FALSE, null, "%G - %t", null, null);
            }
        });
    }

    static String getCacheName(ServiceName deploymentUnitServiceName) {
        if (Services.JBOSS_DEPLOYMENT_SUB_UNIT.isParentOf(deploymentUnitServiceName)) {
            return deploymentUnitServiceName.getParent().getSimpleName() + "/" + deploymentUnitServiceName.getSimpleName();
        }
        return deploymentUnitServiceName.getSimpleName();
    }

    public InfinispanBeanManagerFactoryBuilderFactory(String name, BeanManagerFactoryBuilderConfiguration config) {
        this.name = name;
        this.config = config;
    }

    public Collection<Builder<?>> getDeploymentBuilders(final ServiceName name) {
        String cacheName = InfinispanBeanManagerFactoryBuilderFactory.getCacheName(name);
        String containerName = this.config.getContainerName();
        String templateCacheName = this.config.getCacheName();
        if (templateCacheName == null) {
            templateCacheName = "default";
        }
        ArrayList builders = new ArrayList(4);
        builders.add((Builder<?>)new TemplateConfigurationBuilder(containerName, cacheName, templateCacheName));
        builders.add((Builder<?>)new CacheBuilder<Object, Object>(containerName, cacheName){

            public ServiceBuilder<Cache<Object, Object>> build(ServiceTarget target) {
                return super.build(target).addDependency(name.append(new String[]{"marshalling"}));
            }
        });
        builders.add((Builder<?>)new RemoveOnCancelScheduledExecutorServiceBuilder(name.append(new String[]{this.name, "expiration"}), EXPIRATION_THREAD_FACTORY));
        builders.add((Builder<?>)new CachedThreadPoolExecutorServiceBuilder(name.append(new String[]{this.name, "eviction"}), EVICTION_THREAD_FACTORY));
        return builders;
    }

    public <T> Builder<? extends BeanManagerFactory<I, T, TransactionBatch>> getBeanManagerFactoryBuilder(BeanContext context) {
        return new InfinispanBeanManagerFactoryBuilder(this.name, context, this.config);
    }
}

